/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.algorithm;

import java.time.Instant;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.limiter.Limiter;
import kd.bos.limiter.algorithm.SlidingWindowNode;

public class RequestsCleaner {
    private static final AtomicBoolean IS_TASK_STARTED = new AtomicBoolean(false);
    public static final long DELAY = 60L;

    public static void start() {
        if (IS_TASK_STARTED.compareAndSet(false, true)) {
            Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(RequestsCleaner::remove, 60L, 60L, TimeUnit.SECONDS);
        }
    }

    private static void remove() {
        Map<String, SlidingWindowNode> map = Limiter.getSlidingWindowNodeMap();
        if (map != null && map.size() > 0) {
            map.forEach((key, value) -> value.removeRequest(Instant.now()));
        }
    }
}

