/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.algorithm;

import java.time.Instant;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.limiter.scene.Scene;

public class SlidingWindowNode {
    private Queue<Instant> requests = new LinkedList<Instant>();
    private final Lock lock = new ReentrantLock();
    private final Scene scene;
    private final long windowTime;

    public SlidingWindowNode(Scene scene) {
        this.scene = scene;
        this.windowTime = TimeUnit.MILLISECONDS.convert(scene.getWindowTime(), scene.getWindowTimeUnit());
    }

    public void allowRequest() {
        block5: {
            this.lock.lock();
            try {
                Instant now = Instant.now();
                while (!this.requests.isEmpty() && now.toEpochMilli() - this.requests.peek().toEpochMilli() > this.windowTime) {
                    this.requests.poll();
                }
                if ((long)this.requests.size() < this.scene.getMaxCount()) {
                    this.requests.add(now);
                    break block5;
                }
                String msg = "Operate was terminated by Limiter. code: " + this.scene.getName() + " maxCount: " + this.scene.getMaxCount();
                EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
                throw new KDException(BosErrorCode.limitOverMaxCount, new Object[]{msg});
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    void removeRequest(Instant now) {
        this.lock.lock();
        try {
            while (!this.requests.isEmpty() && now.toEpochMilli() - this.requests.peek().toEpochMilli() > this.windowTime) {
                this.requests.poll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getRequestSize() {
        return this.requests != null ? this.requests.size() : 0;
    }
}

