/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.algorithm;

import kd.bos.limiter.scene.Scene;
import kd.bos.thread.ThreadTruck;

public abstract class ThreadCount {
    public static final String PREFIX_COUNT_KEY = "LIMITER_COUNT_";
    public static final String PREFIX_IS_INIT = "LIMITER_IS_INIT_";
    protected Scene scene;
    private String threadCountKey;
    private String threadIsInit;

    protected ThreadCount(Scene scene) {
        this.scene = scene;
        this.threadCountKey = PREFIX_COUNT_KEY + scene.getCode();
        this.threadIsInit = PREFIX_IS_INIT + scene.getCode();
    }

    public void allowRequest() {
        this.counterInit();
        long maxCount = this.scene.getMaxCount();
        if (maxCount <= 0L) {
            return;
        }
        this.check();
    }

    protected abstract void check();

    protected void counterInit() {
        if (this.isInit()) {
            return;
        }
        Object count = ThreadTruck.get((Object)this.threadCountKey);
        if (count == null) {
            ThreadTruck.put((Object)this.threadCountKey, (Object)0L);
        }
        ThreadTruck.put((Object)this.threadIsInit, (Object)true);
    }

    private boolean isInit() {
        Object isInit = ThreadTruck.get((Object)this.threadIsInit);
        try {
            if (isInit != null && ((Boolean)isInit).booleanValue()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    protected Object getCountInThread() {
        return ThreadTruck.get((Object)this.threadCountKey);
    }

    protected void setCountIntoThread(long count) {
        ThreadTruck.put((Object)this.threadCountKey, (Object)count);
    }
}

