/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.conf;

public class RateLimiterConfig {
    public static long getHashExpireTime() {
        return Long.getLong("rateLimiter.concurrency.cluster.hash.ExpireTime", 7200L);
    }

    public static boolean isLogSlow() {
        return Boolean.parseBoolean(System.getProperty("rateLimiter.concurrency.cluster.slowRecord.enable", "false"));
    }

    public static long getSlowRecordExpireTime() {
        return Long.getLong("rateLimiter.concurrency.cluster.slowRecord.expireTime", 1800L);
    }

    public static int getConcurrentMapMaxSize() {
        return Integer.getInteger("rateLimiter.concurrency.node.concurrentHashMap.maxSize", 100000);
    }

    public static int getCacheMaxSize() {
        return Integer.getInteger("rateLimiter.concurrency.node.cache.maxSize", 500);
    }

    public static int getDuplicateCoreSize() {
        return Integer.getInteger("rateLimiter.duplicate.corePoolSize", 5);
    }

    public static int getDuplicateMaxSize() {
        return Integer.getInteger("rateLimiter.duplicate.maxPoolSize", 10);
    }

    public static int getQueueCapacity() {
        return Integer.getInteger("rateLimiter.duplicate.queue.capacity", 10000);
    }
}

