/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.constant;

public enum Algorithm {
    COUNTER(0),
    FIXED_WINDOW(1),
    SLIDING_WINDOW(2),
    TOKEN_BUCKET(3),
    LEAKY_BUCKET(4);

    private int code;

    private Algorithm(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static Algorithm getAlgorithm(String code) {
        Algorithm ret;
        int c = Integer.parseInt(code);
        switch (c) {
            case 0: {
                ret = COUNTER;
                break;
            }
            case 1: {
                ret = FIXED_WINDOW;
                break;
            }
            case 2: {
                ret = SLIDING_WINDOW;
                break;
            }
            case 3: {
                ret = TOKEN_BUCKET;
                break;
            }
            case 4: {
                ret = LEAKY_BUCKET;
                break;
            }
            default: {
                throw new RuntimeException("Algorithm not supported, code = " + code);
            }
        }
        return ret;
    }
}

