/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.impl;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.context.RequestContext;
import kd.bos.id.ID;
import kd.bos.ksql.shell.timeout.CancelTaskManager;
import kd.bos.limiter.AbstractLimiter;
import kd.bos.limiter.conf.RateLimiterConfig;
import kd.bos.limiter.constant.Range;
import kd.bos.limiter.impl.ClusterSlowRecorder;
import kd.bos.limiter.scene.ConcurrentInstance;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.limiter.scheduler.HeartbeatRedisScheduler;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConcurrencyLimiter
extends AbstractLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConcurrencyLimiter.class);

    public ClusterConcurrencyLimiter(ConcurrentScene scene, String bizCode) {
        this.scene = scene;
        this.sceneCode = scene.getSceneCode();
        this.bizCode = bizCode;
        this.tenantID = RequestContext.get().getTenantId();
        this.storeKey = ClusterConcurrencyLimiter.getStoreKey(this.sceneCode, bizCode);
    }

    @Override
    protected boolean allow() {
        block61: {
            if (this.scene.getLimitType() != 0 || this.scene.getRange() != Range.CLUSTER.getCode()) {
                LOGGER.error("limitType or Range error. LimitType=" + this.scene.getLimitType() + ", Range=" + this.scene.getRange());
                return true;
            }
            long now = System.currentTimeMillis();
            try {
                long l;
                Map allData = null;
                JedisClient jedis = ClusterConcurrencyLimiter.getJedisClient();
                Object object = null;
                try {
                    l = jedis.hlen(this.storeKey);
                    if (l > 0L && l < 10000L) {
                        allData = jedis.hgetAll(this.storeKey);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (jedis != null) {
                        if (object != null) {
                            try {
                                jedis.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            jedis.close();
                        }
                    }
                }
                if (allData != null && allData.size() > 0) {
                    ArrayList<String> delList = new ArrayList<String>();
                    for (Map.Entry entry : allData.entrySet()) {
                        long timestamp;
                        String field = (String)entry.getKey();
                        String[] strings = ((String)entry.getValue()).split("_");
                        if (strings.length < 2 || now - (timestamp = Long.parseLong(strings[1])) <= this.scene.getLockTimeout() * 1000L && (!this.scene.isSingleUserLimit1() || !ClusterConcurrencyLimiter.getCurrUserID().equals(strings[0]))) continue;
                        delList.add(field);
                        if (!this.scene.isTimeoutKillSQL()) continue;
                        try {
                            long threadID = Long.parseLong(strings[2]);
                            String traceID = strings[3];
                            if (StringUtils.isEmpty((String)traceID) || "null".equals(traceID)) continue;
                            CancelTaskManager.get().killQueryCancelTask(threadID, traceID);
                        }
                        catch (Exception e) {
                            LOGGER.error("Kill SQL ERROR.", (Throwable)e);
                        }
                    }
                    if (delList.size() > 0) {
                        Throwable throwable = null;
                        try (JedisClient jedis2 = ClusterConcurrencyLimiter.getJedisClient();){
                            jedis2.hdel(this.storeKey, delList.toArray(new String[0]));
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throw throwable2;
                        }
                    }
                }
                this.uniqueID = Long.toString(ID.genLongId());
                String value = this.getRedisHashValue(now);
                String lua = "if redis.call('HLEN', KEYS[1]) < tonumber(ARGV[1]) then redis.call('HSET', KEYS[1], ARGV[2], ARGV[3]) return 1 else return 0 end";
                try (JedisClient jedis3 = ClusterConcurrencyLimiter.getJedisClient();){
                    l = (Long)jedis3.eval(lua, 1, new String[]{this.storeKey, Long.toString(this.scene.getConcurrency()), this.uniqueID, value});
                }
                if (l != 1L) break block61;
                var9_16 = null;
                try (JedisClient jedis2 = ClusterConcurrencyLimiter.getJedisClient();){
                    jedis2.expire(this.storeKey, RateLimiterConfig.getHashExpireTime());
                }
                catch (Throwable throwable) {
                    var9_16 = throwable;
                    throw throwable;
                }
                if (this.isHeartbeat) {
                    HeartbeatRedisScheduler.add(this.storeKey, this.uniqueID, value);
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.error("ClusterConcurrencyLimiter: An error occurred while acquiring. ", (Throwable)e);
                return true;
            }
        }
        return false;
    }

    @Override
    public void release() {
        ClusterConcurrencyLimiter.release(this.storeKey, this.uniqueID, this.scene.getSlowThreshold());
    }

    public static void release(String concurrentID) {
        ConcurrentInstance instance;
        try {
            instance = ClusterConcurrencyLimiter.decode(concurrentID);
        }
        catch (Exception e) {
            LOGGER.error("decode failed. concurrentID = " + concurrentID + ", " + e.getMessage());
            return;
        }
        if (instance != null) {
            String sceneCode = instance.getSceneCode();
            String key = ClusterConcurrencyLimiter.getStoreKey(sceneCode, instance.getBizCode());
            ConcurrentScene scene = ConcurrentSceneManager.getScene(sceneCode);
            if (scene == null) {
                LOGGER.error("decode failed. concurrentID = " + concurrentID);
                return;
            }
            ClusterConcurrencyLimiter.release(key, instance.getUniqueID(), scene.getSlowThreshold());
        }
    }

    private static void release(String key, String uniqueID, long slowThreshold) {
        try (JedisClient jedis = ClusterConcurrencyLimiter.getJedisClient();){
            String value = jedis.hget(key, uniqueID);
            ClusterSlowRecorder.record(key, value, slowThreshold);
            jedis.hdel(key, new String[]{uniqueID});
        }
    }

    @Override
    public void close() throws Exception {
        if (this.isHeartbeat) {
            HeartbeatRedisScheduler.remove(this.storeKey, this.uniqueID);
        }
        this.release();
    }

    private String getRedisHashValue(long now) {
        String id;
        StringBuilder valueBuilder = new StringBuilder();
        valueBuilder.append(ClusterConcurrencyLimiter.getCurrUserID());
        valueBuilder.append("_");
        valueBuilder.append(now);
        valueBuilder.append("_");
        valueBuilder.append(Thread.currentThread().getId());
        valueBuilder.append("_");
        String traceId = "null";
        RequestContext context = RequestContext.get();
        if (context != null && !StringUtils.isEmpty((String)(id = context.getTraceId()))) {
            traceId = id;
        }
        valueBuilder.append(traceId);
        return valueBuilder.toString();
    }

    static JedisClient getJedisClient() {
        String configKey = CacheConfigKeys.getSessionlessConfigKey((String)"rate_limiter");
        String url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            url = System.getProperty(configKey);
        }
        return RedisFactory.getJedisClient((String)url);
    }
}

