/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.impl;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.limiter.conf.RateLimiterConfig;
import kd.bos.limiter.impl.ClusterConcurrencyLimiter;
import kd.bos.redis.JedisClient;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSlowRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSlowRecorder.class);
    public static final String LOG_KEY_SUFFIX = "_log";
    private static final ExecutorService loggerService = new ThreadPoolExecutor(3, 5, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), new ThreadPoolExecutor.DiscardPolicy());

    static void record(String redisKey, String value, long slowThreshold) {
        if (RateLimiterConfig.isLogSlow()) {
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            long endTime = Instant.now().toEpochMilli();
            loggerService.execute(() -> {
                block16: {
                    try {
                        String[] strings = value.split("_");
                        if (strings.length < 2) break block16;
                        String userID = strings[0];
                        String timestamp = strings[1];
                        if (StringUtils.isEmpty((String)userID)) {
                            return;
                        }
                        if (StringUtils.isEmpty((String)timestamp)) {
                            return;
                        }
                        long startTime = Long.parseLong(timestamp);
                        if (endTime - startTime <= slowThreshold * 1000L) break block16;
                        String logKey = redisKey + LOG_KEY_SUFFIX;
                        String lua = "redis.call('zremrangebyscore', KEYS[1], 0, ARGV[1]) redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]) ";
                        long now = Instant.now().toEpochMilli();
                        try (JedisClient jedisClient = ClusterConcurrencyLimiter.getJedisClient();){
                            jedisClient.eval(lua, 1, new String[]{logKey, Long.toString(now - RateLimiterConfig.getSlowRecordExpireTime() * 1000L), Long.toString(now), userID});
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                    }
                }
            });
        }
    }

    static boolean hasSlow(String sceneCode, String bizCode, String condition) {
        Double ret;
        String key = ClusterConcurrencyLimiter.getStoreKey(sceneCode, bizCode);
        key = key + LOG_KEY_SUFFIX;
        String member = ClusterConcurrencyLimiter.getCurrUserID();
        if (!StringUtils.isEmpty((String)condition)) {
            member = member + "_" + Base64.getEncoder().encodeToString(condition.getBytes(StandardCharsets.UTF_8));
        }
        try (JedisClient jedis = ClusterConcurrencyLimiter.getJedisClient();){
            ret = jedis.zscore(key, member);
        }
        return ret != null && ret > 0.0;
    }
}

