/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.id.ID;
import kd.bos.limiter.JClient;
import kd.bos.limiter.constant.Range;
import kd.bos.limiter.constant.SceneType;
import kd.bos.limiter.constant.TmpTableAction;
import kd.bos.limiter.constant.TmpTableLimitType;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.limiter.impl.LockInfo;
import kd.bos.limiter.impl.TmpTableInitConfig;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.redis.JedisClient;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmpTableLimiter
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmpTableLimiter.class);
    public static final String SCENE_CODE_SUFFIX = "TMP_TABLE_";
    public static final int MIN_LOCK_TIME = 120;
    public Set<ConcurrencyLimiter> limiters = new HashSet<ConcurrencyLimiter>();

    public static TmpTableLimiter acquire(TmpTableAction action, Map<TmpTableLimitType, String> limitMap) {
        if (action == null || limitMap == null || limitMap.size() == 0 || limitMap.size() > 10) {
            return new TmpTableLimiter();
        }
        TmpTableLimiter tmpTableLimiter = new TmpTableLimiter();
        for (Map.Entry<TmpTableLimitType, String> entry : limitMap.entrySet()) {
            String bizCode;
            String sceneCode;
            ConcurrencyLimiter concurrencyLimiter;
            if (StringUtils.isEmpty((String)entry.getValue()) || (concurrencyLimiter = ConcurrencyLimiter.acquire(sceneCode = SCENE_CODE_SUFFIX + entry.getKey().getName(), bizCode = entry.getValue() + "_" + action.getName(), true)).getNoLimit()) continue;
            tmpTableLimiter.addLimiter(concurrencyLimiter);
        }
        return tmpTableLimiter;
    }

    public static void init(Set<TmpTableInitConfig> configs) {
        if (configs == null || configs.size() == 0) {
            return;
        }
        Date now = new Date();
        for (TmpTableInitConfig config : configs) {
            if (config.getTmpTableLimitType() == null || config.getConcurrency() < 1L) continue;
            if (config.getLockTimeout() < 120L) {
                config.setLockTimeout(120L);
            }
            ConcurrentScene scene = new ConcurrentScene();
            String code = SCENE_CODE_SUFFIX + config.getTmpTableLimitType().getName();
            scene.setSceneName(code);
            scene.setSceneCode(code);
            scene.setFid(ID.genLongId());
            scene.setSceneType(SceneType.TEMPTABLE.getCode());
            scene.setLimitType(0);
            scene.setRange(Range.CLUSTER.getCode());
            scene.setTenantIsolation(config.isTenantIsolation());
            scene.setConcurrency(config.getConcurrency());
            scene.setLockTimeout(config.getLockTimeout());
            scene.setTimeoutKillSQL(false);
            scene.setSingleUserLimit1(false);
            scene.setLimitEnable(true);
            scene.setCreated(now);
            ConcurrentSceneManager.scenes.putIfAbsent(code, scene);
        }
    }

    public static LockInfo getLockInfo(TmpTableAction action, TmpTableLimitType type, DBRoute dbRoute) {
        LockInfo info;
        block14: {
            info = new LockInfo();
            try {
                long len;
                String sceneCode = SCENE_CODE_SUFFIX + type.getName();
                ConcurrentScene scene = ConcurrentSceneManager.scenes.get(sceneCode);
                if (scene == null || scene.getRange() != Range.CLUSTER.getCode()) break block14;
                info.setMaxConcurrency(scene.getConcurrency());
                String bizCode = TmpTableLimiter.getDBInstanceByRouteKey(dbRoute.getRouteKey()) + "_" + action.getName();
                String key = TmpTableLimiter.getStoreKey(sceneCode, bizCode, scene.isTenantIsolation());
                try (JedisClient jedis = JClient.get();){
                    len = jedis.hlen(key);
                }
                info.setNowConcurrency(len);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        return info;
    }

    public static LockInfo getLockInfo(TmpTableAction action, DBRoute dbRoute) {
        return TmpTableLimiter.getLockInfo(action, TmpTableLimitType.DB_INSTANCE, dbRoute);
    }

    public static String getDBInstanceByRouteKey(String routeKey) {
        RequestContextInfo rc = RequestContextInfo.get();
        DataSourceInfo dataSourceInfo = DataSourceFactory.getDataSource((String)rc.getTenantId(), (String)routeKey, (String)rc.getAccountId(), (boolean)false);
        DBConfig dbConfig = dataSourceInfo.getDBConfig();
        if (dbConfig.isCluster()) {
            return dbConfig.getClusterDbUrl();
        }
        return String.format("%s:%d", dbConfig.getIp(), dbConfig.getPort());
    }

    public static String getStoreKey(String sceneCode, String bizCode, boolean isTenantIsolation) {
        if (StringUtils.isEmpty((String)sceneCode) || StringUtils.isEmpty((String)bizCode)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RATE_LIMITER_");
        stringBuilder.append(sceneCode);
        stringBuilder.append("_");
        stringBuilder.append(bizCode);
        if (isTenantIsolation) {
            RequestContext context = RequestContext.get();
            if (context == null || StringUtils.isEmpty((String)context.getTenantId())) {
                return null;
            }
            stringBuilder.append("_");
            stringBuilder.append(context.getTenantId());
        }
        return stringBuilder.toString();
    }

    private void addLimiter(ConcurrencyLimiter limiter) {
        this.limiters.add(limiter);
    }

    @Override
    public void close() throws Exception {
        if (this.limiters.size() > 0) {
            for (ConcurrencyLimiter limiter : this.limiters) {
                limiter.close();
            }
        }
    }
}

