/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.scene;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.limiter.constant.SceneType;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.util.StringUtils;

public class ConcurrentSceneManager {
    public static ConcurrentHashMap<String, ConcurrentScene> scenes = new ConcurrentHashMap();
    private static final Log log = LogFactory.getLog(ConcurrentSceneManager.class);

    public static ConcurrentScene getScene(String sceneCode) {
        if (StringUtils.isEmpty((String)sceneCode)) {
            return null;
        }
        return scenes.get(sceneCode);
    }

    public static List<ConcurrentScene> getScenes(SceneType sceneType) {
        ArrayList<ConcurrentScene> ret = new ArrayList<ConcurrentScene>();
        scenes.values().forEach(scene -> {
            if (sceneType.getCode() == scene.getSceneType()) {
                ret.add((ConcurrentScene)scene);
            }
        });
        return ret;
    }

    public static void init() {
        try {
            String selectSql = "select top 1000 fid,fscene_name,fscene_code,fscene_type,flimit_type,frange,ftenant_isolation,fconcurrency,flock_timeout,ftimeout_kill_sql,fsingle_user_limit_1,fslow_time,fduplicate_window_time,flimit_enable,fcreated,fupdated from T_MONITOR_RATELIMITER_SCENE";
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(selectSql, null));
            List returnList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            for (Result row : returnList) {
                ConcurrentScene concurrentScene = new ConcurrentScene();
                concurrentScene.setFid(Long.parseLong(row.getString("fid")));
                concurrentScene.setSceneName(row.getString("fscene_name"));
                String fscene_code = row.getString("fscene_code");
                concurrentScene.setSceneCode(fscene_code);
                concurrentScene.setSceneType(Integer.parseInt(row.getString("fscene_type")));
                concurrentScene.setLimitType(Integer.parseInt(row.getString("flimit_type")));
                concurrentScene.setRange(Integer.parseInt(row.getString("frange")));
                concurrentScene.setTenantIsolation(row.getString("ftenant_isolation").equals("1"));
                concurrentScene.setConcurrency(Long.parseLong(row.getString("fconcurrency")));
                concurrentScene.setLockTimeout(Long.parseLong(row.getString("flock_timeout")));
                concurrentScene.setTimeoutKillSQL(row.getString("ftimeout_kill_sql").equals("1"));
                concurrentScene.setSingleUserLimit1(row.getString("fsingle_user_limit_1").equals("0"));
                concurrentScene.setSlowThreshold(Long.parseLong(row.getString("fslow_time")));
                concurrentScene.setDuplicateWindowTime(Long.parseLong(row.getString("fduplicate_window_time")));
                concurrentScene.setLimitEnable(row.getString("flimit_enable").equals("1"));
                concurrentScene.setCreated(DateUtils.parseDateTime((String)row.getString("fcreated"), (String)"yyyy-MM-dd HH:mm:ss"));
                concurrentScene.setUpdated(row.getString("fupdated") == null ? null : DateUtils.parseDateTime((String)row.getString("fupdated"), (String)"yyyy-MM-dd HH:mm:ss"));
                scenes.put(fscene_code, concurrentScene);
            }
            log.info("ConcurrentSceneManager init success, Loaded scene total = " + scenes.size());
        }
        catch (Exception e) {
            log.warn("ConcurrentSceneManager init error", (Throwable)e);
        }
    }
}

