/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.limiter.Limiter;
import kd.bos.limiter.algorithm.FixedWindowCluster;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class FixedWindowScheduler {
    private FixedWindowScheduler() {
        if (Holder.INSTANCE != null) {
            throw new IllegalStateException("Already initialized.");
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        long delay = 5L;
        service.scheduleWithFixedDelay(() -> {
            for (FixedWindowCluster fixedWindowCluster : Limiter.FIXED_WINDOW_CLUSTER_MAP.values()) {
                try {
                    if (!fixedWindowCluster.getIsAsync() || fixedWindowCluster.tempCounter.get() <= 0L) continue;
                    String expire = "0";
                    switch (fixedWindowCluster.AsyncWindowTime) {
                        case MINUTES: {
                            expire = "90";
                            break;
                        }
                        case HOURS: {
                            expire = "5400";
                            break;
                        }
                        case DAYS: {
                            expire = "129600";
                        }
                    }
                    String luaScript = "if redis.call('EXISTS', KEYS[1]) == 1 then redis.call('incrby', KEYS[1], ARGV[1]) else redis.call('incrby', KEYS[1], ARGV[1]) redis.call('expire', KEYS[1], ARGV[2]) end";
                    String configKey = CacheConfigKeys.getSessionlessConfigKey((String)"rate_limiter");
                    String url = System.getProperty(configKey);
                    if (url == null) {
                        configKey = CacheConfigKeys.getSessionlessConfigKey(null);
                        url = System.getProperty(configKey);
                    }
                    try (JedisClient jedis = RedisFactory.getJedisClient((String)url);){
                        jedis.eval(luaScript, 1, new String[]{fixedWindowCluster.getAsyncKey(), Long.toString(fixedWindowCluster.tempCounter.getAndSet(0L)), expire});
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (Exception exception) {}
            }
        }, delay, TimeUnit.SECONDS.toSeconds(delay), TimeUnit.SECONDS);
    }

    public static FixedWindowScheduler getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final FixedWindowScheduler INSTANCE = new FixedWindowScheduler();

        private Holder() {
        }
    }
}

