/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis;

import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.redis.RedisProtocols;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.topology.TopologyTagInject;

public class RedisGovern {
    static void entry(String url) {
        RedisGovern.doTrace(url);
        RedisGovern.handleRequestTimeout();
    }

    private static void doTrace(String url) {
        if (Tracer.getCurrentSpan() != null) {
            String tempUrl = url;
            if (tempUrl != null && tempUrl.contains("/")) {
                tempUrl = tempUrl.split("/")[0];
            }
            String destComponent = RedisProtocols.isXCache(url) ? "XCache" : "Redis";
            TopologyTagInject.setCompentTag((InnerSpan)Tracer.getCurrentSpan().getInnerSpan(), (String)tempUrl, (String)destComponent, (String)"redis");
        }
    }

    private static void handleRequestTimeout() {
        TimeoutHandleFactory.get().handleTimeout();
    }
}

