/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.analysis;

public class Sizes {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;

    private Sizes() {
    }

    public static String format(long s) {
        if (s == Long.MIN_VALUE) {
            return String.format("%.1fG", (double)s / 1.073741824E9);
        }
        return s >= 0L ? Sizes.doPositiveFormat(s) : String.format("-%s", Sizes.doPositiveFormat(-s));
    }

    private static String doPositiveFormat(long size) {
        if (size < 1024L) {
            return String.format("%s", size);
        }
        if (size < 0x100000L) {
            return Sizes.formatDouble(size, 1024L, "K");
        }
        if (size < 0x40000000L) {
            return Sizes.formatDouble(size, 0x100000L, "M");
        }
        return Sizes.formatDouble(size, 0x40000000L, "G");
    }

    private static String formatDouble(double size, long base, String suffix) {
        return String.format("%.1f%s", size / (double)base, suffix);
    }
}

