/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.custom.tong;

import java.nio.ByteBuffer;

public class TongConfig {
    public static String linsert_lua = "local listKey = KEYS[1]\nlocal valueToInsert = ARGV[1]\nlocal afterValue = ARGV[2]\nlocal insertAfter = tonumber(ARGV[3])\n\n-- 1. Get all elements from list to 'allElements'\nlocal allElements = redis.call('lrange', listKey, 0, -1)\n\n-- 2. Find index of afterValue at the list\nlocal insertIndex = -1\nfor i, v in ipairs(allElements) do\n    if v == afterValue then\n        insertIndex = i\n        break\n    end\nend\n\n-- 3. If not found or last one, push to the last of the last, then return\nif insertIndex == -1 or insertIndex == #allElements then\n    return redis.call('rpush', listKey, valueToInsert)\nend\n\n-- 4. Insert to the 'allElements'\nif insertAfter == 0 then\n    table.insert(allElements, insertIndex, valueToInsert)\nelse\n    table.insert(allElements, insertIndex + 1, valueToInsert)\nend\n\n-- 5. Clear the old list\nredis.call('del', listKey)\n\n-- 6. Insert the 'allElements' to list\nfor _, v in ipairs(allElements) do\n    redis.call('rpush', listKey, v)\nend\n\nreturn 1";

    public static boolean enableEval() {
        return Boolean.parseBoolean(System.getProperty("redis.client.eval.enable", "true"));
    }

    public static byte[] intToBytes(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        return buffer.array();
    }
}

