/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.redis.RedisProtocols;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.pool.Pool0Builder;
import kd.bos.redis.pool.builder.ClusterBuilder;
import kd.bos.redis.pool.builder.SentinelBuilder;
import kd.bos.redis.pool.builder.ShardBuilder;
import kd.bos.redis.pool.builder.StandaloneBuilder;
import kd.bos.redis.pool.builder.XCacheHostingBuilder;
import kd.bos.redis.pool.builder.XCacheMServiceBuilder;
import kd.bos.util.Pair;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pool0BuilderImpl {
    private static final Logger logger = LoggerFactory.getLogger(Pool0BuilderImpl.class);
    private static final Map<String, Supplier<Pool0Builder>> protocolAndBuilders = new HashMap<String, Supplier<Pool0Builder>>();

    public static Pool0 getPool(String url) {
        if (StringUtils.isBlank((String)url)) {
            logger.error(url);
            throw new NullPointerException("Redis url can not be null!!");
        }
        Pair<String, String> protocolAndUrl = RedisProtocols.getProtocolAndUrl(url);
        StandaloneBuilder factory = protocolAndBuilders.containsKey(protocolAndUrl.getKey()) ? protocolAndBuilders.get(protocolAndUrl.getKey()).get() : new StandaloneBuilder();
        String poolUrl = (String)protocolAndUrl.getValue();
        boolean ssl = poolUrl.toLowerCase().startsWith("ssl:");
        String string = poolUrl = ssl ? poolUrl.substring(4) : poolUrl;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Protocol: [%s], url: [%s], ssl: [%s], poolUrl: [%s]", protocolAndUrl.getKey(), url, ssl, poolUrl));
        }
        return factory.build(poolUrl, ssl);
    }

    static {
        protocolAndBuilders.put("redis", StandaloneBuilder::new);
        protocolAndBuilders.put("shard", ShardBuilder::new);
        protocolAndBuilders.put("sentinel", SentinelBuilder::new);
        protocolAndBuilders.put("cluster", ClusterBuilder::new);
        protocolAndBuilders.put("xcache_hosting", XCacheHostingBuilder::new);
        protocolAndBuilders.put("xcache_mservice", XCacheMServiceBuilder::new);
    }
}

