/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool.builder;

import java.util.concurrent.TimeUnit;
import kd.bos.redis.pool.Pool0Builder;
import kd.bos.util.SystemProperties;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPoolBuilder<T>
implements Pool0Builder<T> {
    public static final String REDIS_CLIENT_PROPERTY_PREFIX = "redis.client.";
    public static final String REDIS_CLIENT_PROPERTY_CONNECT_TIMEOUT = "redis.client.connectionTimeout";
    public static final String REDIS_CLIENT_PROPERTY_SOCKET_TIMEOUT = "redis.client.soTimeout";
    public static final int DEFAULT_TIME_OUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(5L);

    public int connectionTimeout() {
        return AbstractPoolBuilder.getTimeout(REDIS_CLIENT_PROPERTY_CONNECT_TIMEOUT);
    }

    public int soTimeout() {
        return AbstractPoolBuilder.getTimeout(REDIS_CLIENT_PROPERTY_SOCKET_TIMEOUT);
    }

    private static int getTimeout(String propertyName) {
        String value = SystemProperties.getWithEnv((String)propertyName);
        return StringUtils.isBlank((CharSequence)value) ? DEFAULT_TIME_OUT_MILLIS : Integer.parseInt(value);
    }
}

