/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool.builder;

import java.util.HashSet;
import java.util.Set;
import kd.bos.encrypt.Encrypters;
import kd.bos.redis.pool.JedisPool0;
import kd.bos.redis.pool.JedisPoolConfigGeneral;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.pool.Pool0Builder;
import kd.bos.redis.pool.builder.AbstractPoolBuilder;
import kd.bos.redis.pool.builder.PoolMetric;
import kd.bos.redis.pool.builder.RedisInfoParser;
import kd.bos.redis.pool.builder.bean.RedisInfo;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

public class SentinelBuilder
extends AbstractPoolBuilder<Jedis>
implements Pool0Builder<Jedis> {
    private static final String MASTERNAME = "mymaster";
    private static final String MASTERNAME_KEY = "mastername";
    private static final String PASS = "password";
    private static final String SENTINEL_PASSWORD = "sentinelpassword";
    private static final Logger logger = LoggerFactory.getLogger(SentinelBuilder.class);

    @Override
    public Pool0<Jedis> build(String url, boolean ssl) {
        JedisSentinelPool pool;
        String password = null;
        String masterName = MASTERNAME;
        String sentinelPassword = null;
        RedisInfo redisInfo = RedisInfoParser.parseUrl(url);
        if (redisInfo.getProperties() != null) {
            masterName = redisInfo.getProperties().getProperty(MASTERNAME_KEY, MASTERNAME);
            password = redisInfo.getProperties().getProperty(PASS);
            sentinelPassword = redisInfo.getProperties().getProperty(SENTINEL_PASSWORD);
        } else {
            password = redisInfo.getPassword();
        }
        Set<String> sentinelHosts = this.parseServer(redisInfo);
        JedisPoolConfig config = new JedisPoolConfigGeneral().getPoolConfig();
        if (sentinelPassword == null) {
            pool = new JedisSentinelPool(masterName, sentinelHosts, (GenericObjectPoolConfig<Jedis>)config, this.connectionTimeout(), this.soTimeout(), null, password, 0);
        } else {
            sentinelPassword = Encrypters.decode((String)sentinelPassword);
            pool = new JedisSentinelPool(masterName, sentinelHosts, (GenericObjectPoolConfig<Jedis>)config, this.connectionTimeout(), this.soTimeout(), password, 0, null, this.connectionTimeout(), this.soTimeout(), sentinelPassword, null);
        }
        String metricUrl = url.replaceAll(":", "-");
        PoolMetric.setPool((Pool)((Object)pool), metricUrl, config.getMaxTotal());
        return new JedisPool0<Jedis>((Pool<Jedis>)((Object)pool));
    }

    private Set<String> parseServer(RedisInfo redisInfo) {
        HashSet<String> sentinelHosts = new HashSet<String>();
        redisInfo.getHostAndPorts().forEach(hostAndPort -> sentinelHosts.add(hostAndPort.toString()));
        return sentinelHosts;
    }
}

