/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool.builder;

import kd.bos.redis.pool.JedisPoolConfigGeneral;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.pool.Pool0Builder;
import kd.bos.redis.pool.builder.AbstractPoolBuilder;
import kd.bos.redis.pool.builder.PoolMetric;
import kd.bos.redis.pool.builder.RedisInfoParser;
import kd.bos.redis.pool.builder.bean.HostAndPort;
import kd.bos.redis.pool.builder.bean.RedisInfo;
import kd.bos.redis.xcache.XCacheJedisClient;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.util.Pool;

public class XCacheHostingBuilder
extends AbstractPoolBuilder<XCacheJedisClient>
implements Pool0Builder<XCacheJedisClient> {
    private static final String MODULE = "xcache-client.hosting";

    @Override
    public Pool0<XCacheJedisClient> build(String url, boolean ssl) {
        return new XCacheHostPool(XCacheHostingBuilder.createXCachePool(MODULE, url, this.connectionTimeout(), this.soTimeout()));
    }

    public static Pool<Jedis> createXCachePool(String module, String url, int connectionTimeout, int soTimeout) {
        RedisInfo redisInfo = XCacheHostingBuilder.parseUrl(url);
        HostAndPort hostAndPort = redisInfo.getHostAndPorts().iterator().next();
        JedisPoolConfig config = new JedisPoolConfigGeneral().getPoolConfig();
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, hostAndPort.getHost(), hostAndPort.getPort(), connectionTimeout, soTimeout, redisInfo.getPassword(), 0, null, false);
        String metricUrl = url.replaceAll(":", "-");
        PoolMetric.setPool((Pool)pool, metricUrl, config.getMaxTotal(), module);
        return pool;
    }

    public static RedisInfo parseUrl(String url) {
        RedisInfo redisInfo;
        try {
            redisInfo = RedisInfoParser.parseUrl(url);
        }
        catch (Exception e) {
            throw new InvalidURIException(XCacheHostingBuilder.getInvalidURIExceptionMessage(url), (Throwable)e);
        }
        if (redisInfo.getHostAndPorts().isEmpty()) {
            throw new InvalidURIException(XCacheHostingBuilder.getInvalidURIExceptionMessage(url));
        }
        return redisInfo;
    }

    private static String getInvalidURIExceptionMessage(String url) {
        return String.format("Invalid xcache hosting url: [%s]", url);
    }

    private static class XCacheHostPool
    implements Pool0<XCacheJedisClient> {
        private final Pool<Jedis> pool;

        public XCacheHostPool(Pool<Jedis> pool) {
            this.pool = pool;
        }

        @Override
        public XCacheJedisClient getResource() {
            return new XCacheJedisClient(this.pool.getResource());
        }
    }
}

