/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool.router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kd.bos.redis.pool.router.Dispatcher;

public class ConsistentHashDispatcher
implements Dispatcher {
    private static final String SPLIT = "#vn";
    private List<String> realNodes;
    private int virtualNum = 200;
    private SortedMap<Integer, String> nodesMap = new TreeMap<Integer, String>();
    private Map<String, List<Integer>> realVirtualMapping = new HashMap<String, List<Integer>>();

    public ConsistentHashDispatcher(List<String> initialList) {
        this.realNodes = new ArrayList<String>(initialList.size());
        initialList.forEach(n -> this.addNode(n.trim()));
    }

    private void addNode(String node) {
        this.realNodes.add(node);
        int count = 0;
        int index = 0;
        ArrayList<Integer> virtualList = new ArrayList<Integer>();
        while (count < this.virtualNum) {
            String vNode = node + SPLIT + ++index;
            int hashVal = ConsistentHashDispatcher.hash(vNode.getBytes());
            if (this.nodesMap.containsKey(hashVal)) continue;
            this.nodesMap.put(hashVal, node);
            virtualList.add(hashVal);
            ++count;
        }
        this.realVirtualMapping.put(node, virtualList);
    }

    @Override
    public String getNode(byte[] key) {
        int hashVal = ConsistentHashDispatcher.hash(key);
        SortedMap<Integer, String> rangeMap = this.nodesMap.tailMap(hashVal);
        if (rangeMap.isEmpty()) {
            return (String)this.nodesMap.get(this.nodesMap.firstKey());
        }
        return (String)rangeMap.get(rangeMap.firstKey());
    }

    @Override
    public List<String> getRealNodes() {
        return this.realNodes;
    }

    private void removeNode(String node) {
        List<Integer> keys = this.realVirtualMapping.get(node);
        if (keys != null && !keys.isEmpty()) {
            keys.forEach(k -> {
                String cfr_ignored_0 = (String)this.nodesMap.remove(k);
            });
        }
        this.realNodes.remove(node);
        this.realVirtualMapping.remove(node);
    }

    private static int hash(byte[] data) {
        int p = 16777619;
        int hash = -2128831035;
        for (byte b : data) {
            hash = (hash ^ b) * 16777619;
            hash += hash << 13;
            hash ^= hash >> 7;
            hash += hash << 3;
            hash ^= hash >> 17;
            hash += hash << 5;
        }
        if (hash < 0) {
            hash = Math.abs(hash);
        }
        return hash;
    }
}

