/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.xcache;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class TopNList<T> {
    private final List<T> list = new ArrayList<T>();
    private final int maxSize;
    private final Comparator<? super T> comparator;

    public TopNList(int maxSize, Comparator<? super T> comparator) {
        this.maxSize = maxSize;
        this.comparator = comparator;
    }

    public boolean insert(T data) {
        if (this.list.size() < this.maxSize) {
            this.insertIntoList(data);
            return true;
        }
        if (this.maxSize > 0 && this.comparator.compare(data, this.list.get(this.list.size() - 1)) > 0) {
            this.list.remove(this.list.size() - 1);
            this.insertIntoList(data);
            return true;
        }
        return false;
    }

    private void insertIntoList(T data) {
        int insertIndex = this.binarySearch(this.list, data);
        this.list.add(insertIndex, data);
    }

    private int binarySearch(List<T> list, T data) {
        int left = 0;
        int right = list.size() - 1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            int cmp = this.comparator.compare(data, list.get(mid));
            if (cmp == 0) {
                return mid;
            }
            if (cmp > 0) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return left;
    }

    public List<T> getList() {
        return this.list;
    }
}

