/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.xcache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.redis.JedisClient;
import kd.bos.redis.analysis.AnalysisResult;
import kd.bos.redis.analysis.BigKeyAnalysis;
import kd.bos.redis.analysis.KeySummary;
import kd.bos.redis.xcache.ScanDataResultCreator;
import kd.bos.redis.xcache.ScanDataSummary;
import kd.bos.redis.xcache.TopNList;
import kd.bos.redis.xcache.XCacheCommands;
import kd.bos.redis.xcache.XCacheJedisClient;
import kd.bos.redis.xcache.XCacheScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.util.SafeEncoder;

public class XCacheClient
implements XCacheCommands,
BigKeyAnalysis {
    protected final JedisClient client;

    public static XCacheClient newClient(JedisClient client) {
        return new XCacheClient(client);
    }

    private XCacheClient(JedisClient client) {
        this.client = client;
    }

    public JedisClient getJedisClient() {
        return this.client;
    }

    @Override
    public ScanResult<ScanDataSummary> scanData(String cursor, XCacheScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)cursor));
        args.addAll(params.getParams());
        Object result = this.client.sendExtendCommand(XCacheJedisClient.Command.SCANDATA, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return ScanDataResultCreator.create(result);
    }

    @Override
    public AnalysisResult<KeySummary> analysis(int kb, int topN) {
        long beginTime = System.currentTimeMillis();
        if (kb <= 0 || topN <= 0) {
            return AnalysisResult.of(beginTime, beginTime, 0L, Collections.emptyList());
        }
        topN = Math.min(1000, topN);
        long analyzedCount = 0L;
        HashSet<String> scannedKeys = new HashSet<String>();
        TopNList<ScanDataSummary> topNList = new TopNList<ScanDataSummary>(topN, Comparator.comparing(ScanDataSummary::getMemoryUsage));
        String cursor = XCacheScanParams.SCAN_POINTER_START;
        XCacheScanParams params = new XCacheScanParams();
        params.count(1000).memory(String.format("%sK", kb));
        do {
            ScanResult<ScanDataSummary> scanResult = this.scanData(cursor, params);
            cursor = scanResult.getCursor();
            for (ScanDataSummary each : scanResult.getResult()) {
                ++analyzedCount;
                if (scannedKeys.contains(each.getKey()) || !topNList.insert(each)) continue;
                scannedKeys.add(each.getKey());
            }
        } while (!XCacheScanParams.SCAN_POINTER_START.equals(cursor));
        List keySummaries = topNList.getList().stream().map(d -> new KeySummary(d.getKey(), d.getType(), d.getMemoryUsage(), d.getLength())).collect(Collectors.toList());
        return AnalysisResult.of(beginTime, System.currentTimeMillis(), analyzedCount, keySummaries);
    }
}

