/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryShardedJedis;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamConsumersInfo;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamGroupInfo;
import redis.clients.jedis.StreamInfo;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.StreamPendingSummary;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.StrAlgoLCSParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.resps.KeyedListElement;
import redis.clients.jedis.resps.LCSMatchResult;
import redis.clients.jedis.util.Hashing;
import redis.clients.jedis.util.Pool;

public class ShardedJedis
extends BinaryShardedJedis
implements JedisCommands,
Closeable {
    protected Pool<ShardedJedis> dataSource = null;

    public ShardedJedis(List<JedisShardInfo> shards) {
        super(shards);
    }

    public ShardedJedis(List<JedisShardInfo> shards, Hashing algo) {
        super(shards, algo);
    }

    public ShardedJedis(List<JedisShardInfo> shards, Pattern keyTagPattern) {
        super(shards, keyTagPattern);
    }

    public ShardedJedis(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        super(shards, algo, keyTagPattern);
    }

    public String set(String key, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value);
    }

    public String set(String key, String value, SetParams setParams) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value, setParams);
    }

    public String set(String key, String value, String nxxx, String expx, long time) {
        SetParams setParams = new SetParams();
        if (nxxx.equalsIgnoreCase("nx")) {
            setParams.nx();
        } else if (nxxx.equalsIgnoreCase("xx")) {
            setParams.xx();
        }
        if (expx.equalsIgnoreCase("ex")) {
            setParams.ex((int)time);
        } else if (expx.equalsIgnoreCase("px")) {
            setParams.px(time);
        }
        return this.set(key, value, setParams);
    }

    public String set(String key, String value, String nxxx) {
        SetParams setParams = new SetParams();
        if (nxxx.equalsIgnoreCase("nx")) {
            setParams.nx();
        } else if (nxxx.equalsIgnoreCase("xx")) {
            setParams.xx();
        }
        return this.set(key, value, setParams);
    }

    public String get(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.get(key);
    }

    public String getDel(String s) {
        return null;
    }

    public String getEx(String s, GetExParams getExParams) {
        return null;
    }

    public String echo(String string) {
        Jedis j = (Jedis)this.getShard(string);
        return j.echo(string);
    }

    public Boolean exists(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.exists(key);
    }

    public String type(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.type(key);
    }

    public byte[] dump(String s) {
        Jedis j = (Jedis)this.getShard(s);
        return j.dump(s);
    }

    public String restore(String s, int i, byte[] bytes) {
        Jedis j = (Jedis)this.getShard(s);
        return j.restore(s, i, bytes);
    }

    public String restore(String s, long l, byte[] bytes) {
        return null;
    }

    public String restoreReplace(String s, int i, byte[] bytes) {
        Jedis j = (Jedis)this.getShard(s);
        return j.restoreReplace(s, i, bytes);
    }

    public String restoreReplace(String s, long l, byte[] bytes) {
        return null;
    }

    public String restore(String s, long l, byte[] bytes, RestoreParams restoreParams) {
        return null;
    }

    public Long expire(String key, int seconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expire(key, seconds);
    }

    public Long expire(String s, long l) {
        return null;
    }

    public Long pexpire(String key, long milliseconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpire(key, milliseconds);
    }

    public Long expireAt(String key, long unixTime) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expireAt(key, unixTime);
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpireAt(key, millisecondsTimestamp);
    }

    public Long ttl(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ttl(key);
    }

    public Long pttl(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pttl(key);
    }

    public Long touch(String s) {
        Jedis j = (Jedis)this.getShard(s);
        return j.touch(s);
    }

    public Boolean setbit(String key, long offset, boolean value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setbit(key, offset, value);
    }

    public Boolean setbit(String key, long offset, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setbit(key, offset, value);
    }

    public Boolean getbit(String key, long offset) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getbit(key, offset);
    }

    public Long setrange(String key, long offset, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setrange(key, offset, value);
    }

    public String getrange(String key, long startOffset, long endOffset) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getrange(key, startOffset, endOffset);
    }

    public String getSet(String key, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getSet(key, value);
    }

    public Long setnx(String key, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setnx(key, value);
    }

    public String setex(String key, int seconds, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setex(key, seconds, value);
    }

    public String setex(String s, long l, String s1) {
        Jedis j = (Jedis)this.getShard(s);
        return j.setex(s, l, s1);
    }

    public String psetex(String key, long milliseconds, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.psetex(key, milliseconds, value);
    }

    public List<String> blpop(String arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.blpop(new String[]{arg});
    }

    public List<String> blpop(int timeout, String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.blpop(timeout, key);
    }

    public KeyedListElement blpop(double v, String s) {
        Jedis j = (Jedis)this.getShard(s);
        return j.blpop(v, s);
    }

    public List<String> brpop(String arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.brpop(new String[]{arg});
    }

    public List<String> brpop(int timeout, String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.brpop(timeout, key);
    }

    public KeyedListElement brpop(double v, String s) {
        return null;
    }

    public Long decrBy(String key, long integer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decrBy(key, integer);
    }

    public Long decr(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decr(key);
    }

    public Long incrBy(String key, long integer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrBy(key, integer);
    }

    public Double incrByFloat(String key, double integer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrByFloat(key, integer);
    }

    public Long incr(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incr(key);
    }

    public Long append(String key, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.append(key, value);
    }

    public String substr(String key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.substr(key, start, end);
    }

    public Long hset(String key, String field, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hset(key, field, value);
    }

    public Long hset(String s, Map<String, String> map) {
        Jedis j = (Jedis)this.getShard(s);
        return j.hset(s, map);
    }

    public String hget(String key, String field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hget(key, field);
    }

    public Long hsetnx(String key, String field, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hsetnx(key, field, value);
    }

    public String hmset(String key, Map<String, String> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmset(key, hash);
    }

    public List<String> hmget(String key, String ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmget(key, fields);
    }

    public Long hincrBy(String key, String field, long value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrBy(key, field, value);
    }

    public Double hincrByFloat(String key, String field, double value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrByFloat(key, field, value);
    }

    public Boolean hexists(String key, String field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hexists(key, field);
    }

    public Long del(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.del(key);
    }

    public Long unlink(String s) {
        Jedis j = (Jedis)this.getShard(s);
        return j.unlink(s);
    }

    public Long hdel(String key, String ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hdel(key, fields);
    }

    public Long hlen(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hlen(key);
    }

    public Set<String> hkeys(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hkeys(key);
    }

    public List<String> hvals(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hvals(key);
    }

    public Map<String, String> hgetAll(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hgetAll(key);
    }

    public String hrandfield(String s) {
        return null;
    }

    public List<String> hrandfield(String s, long l) {
        return null;
    }

    public Map<String, String> hrandfieldWithValues(String s, long l) {
        return null;
    }

    public Long rpush(String key, String ... strings) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpush(key, strings);
    }

    public Long lpush(String key, String ... strings) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpush(key, strings);
    }

    public Long lpushx(String key, String ... string) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpushx(key, string);
    }

    public Long strlen(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.strlen(key);
    }

    public Long move(String key, int dbIndex) {
        Jedis j = (Jedis)this.getShard(key);
        return j.move(key, dbIndex);
    }

    public Long rpushx(String key, String ... string) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpushx(key, string);
    }

    public Long persist(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.persist(key);
    }

    public Long llen(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.llen(key);
    }

    public List<String> lrange(String key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrange(key, start, end);
    }

    public String ltrim(String key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ltrim(key, start, end);
    }

    public String lindex(String key, long index) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lindex(key, index);
    }

    public String lset(String key, long index, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lset(key, index, value);
    }

    public Long lrem(String key, long count, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrem(key, count, value);
    }

    public String lpop(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpop(key);
    }

    public List<String> lpop(String s, int i) {
        return null;
    }

    public Long lpos(String s, String s1) {
        return null;
    }

    public Long lpos(String s, String s1, LPosParams lPosParams) {
        return null;
    }

    public List<Long> lpos(String s, String s1, LPosParams lPosParams, long l) {
        return null;
    }

    public String rpop(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpop(key);
    }

    public List<String> rpop(String s, int i) {
        return null;
    }

    public Long sadd(String key, String ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sadd(key, members);
    }

    public Set<String> smembers(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.smembers(key);
    }

    public Long srem(String key, String ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srem(key, members);
    }

    public String spop(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key);
    }

    public Set<String> spop(String key, long count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key, count);
    }

    public Long scard(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.scard(key);
    }

    public Boolean sismember(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sismember(key, member);
    }

    public List<Boolean> smismember(String s, String ... strings) {
        return null;
    }

    public String srandmember(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key);
    }

    public List<String> srandmember(String key, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key, count);
    }

    public Long zadd(String key, double score, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member);
    }

    public Long zadd(String key, double score, String member, ZAddParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member, params);
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, scoreMembers);
    }

    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, scoreMembers, params);
    }

    public Double zaddIncr(String s, double v, String s1, ZAddParams zAddParams) {
        return null;
    }

    public Set<String> zrange(String key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrange(key, start, end);
    }

    public Long zrem(String key, String ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrem(key, members);
    }

    public Double zincrby(String key, double score, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, score, member);
    }

    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, score, member, params);
    }

    public Long zrank(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrank(key, member);
    }

    public Long zrevrank(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrank(key, member);
    }

    public Set<String> zrevrange(String key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrange(key, start, end);
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeWithScores(key, start, end);
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeWithScores(key, start, end);
    }

    public String zrandmember(String s) {
        return null;
    }

    public Set<String> zrandmember(String s, long l) {
        return null;
    }

    public Set<Tuple> zrandmemberWithScores(String s, long l) {
        return null;
    }

    public Long zcard(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcard(key);
    }

    public Double zscore(String key, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscore(key, member);
    }

    public List<Double> zmscore(String s, String ... strings) {
        return null;
    }

    public Tuple zpopmax(String s) {
        Jedis j = (Jedis)this.getShard(s);
        return j.zpopmax(s);
    }

    public Set<Tuple> zpopmax(String s, int i) {
        Jedis j = (Jedis)this.getShard(s);
        return j.zpopmax(s, i);
    }

    public Tuple zpopmin(String s) {
        Jedis j = (Jedis)this.getShard(s);
        return j.zpopmin(s);
    }

    public Set<Tuple> zpopmin(String s, int i) {
        Jedis j = (Jedis)this.getShard(s);
        return j.zpopmin(s, i);
    }

    public List<String> sort(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key);
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key, sortingParameters);
    }

    public Long zcount(String key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min, max);
    }

    public Long zcount(String key, String min, String max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min, max);
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max);
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min);
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max, offset, count);
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min, offset, count);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max);
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min);
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max, offset, count);
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min, offset, count);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    public Long zremrangeByRank(String key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByRank(key, start, end);
    }

    public Long zremrangeByScore(String key, double start, double end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, start, end);
    }

    public Long zremrangeByScore(String key, String start, String end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, start, end);
    }

    public Long zlexcount(String key, String min, String max) {
        return ((Jedis)this.getShard(key)).zlexcount(key, min, max);
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        return ((Jedis)this.getShard(key)).zrangeByLex(key, min, max);
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        return ((Jedis)this.getShard(key)).zrangeByLex(key, min, max, offset, count);
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        return ((Jedis)this.getShard(key)).zrevrangeByLex(key, max, min);
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        return ((Jedis)this.getShard(key)).zrevrangeByLex(key, max, min, offset, count);
    }

    public Long zremrangeByLex(String key, String min, String max) {
        return ((Jedis)this.getShard(key)).zremrangeByLex(key, min, max);
    }

    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        Jedis j = (Jedis)this.getShard(key);
        ListPosition n = Arrays.equals(where.raw, BinaryClient.LIST_POSITION.BEFORE.raw) ? ListPosition.BEFORE : ListPosition.AFTER;
        return j.linsert(key, n, pivot, value);
    }

    public Long linsert(String key, ListPosition where, String pivot, String value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.linsert(key, where, pivot, value);
    }

    public Long bitcount(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitcount(key);
    }

    public Long bitcount(String key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitcount(key, start, end);
    }

    public Long bitpos(String key, boolean value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitpos(key, value);
    }

    public Long bitpos(String key, boolean value, BitPosParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitpos(key, value, params);
    }

    @Deprecated
    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hscan(key, Integer.toString(cursor));
    }

    @Deprecated
    public ScanResult<String> sscan(String key, int cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sscan(key, Integer.toString(cursor));
    }

    @Deprecated
    public ScanResult<Tuple> zscan(String key, int cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscan(key, Integer.toString(cursor));
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hscan(key, cursor);
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hscan(key, cursor, params);
    }

    public ScanResult<String> sscan(String key, String cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sscan(key, cursor);
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sscan(key, cursor, params);
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscan(key, cursor);
    }

    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscan(key, cursor, params);
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            boolean broken = false;
            for (Jedis jedis : this.getAllShards()) {
                if (!jedis.getClient().isBroken()) continue;
                broken = true;
                break;
            }
            if (broken) {
                this.dataSource.returnBrokenResource(this);
            } else {
                this.dataSource.returnResource(this);
            }
        } else {
            this.disconnect();
        }
    }

    public void setDataSource(Pool<ShardedJedis> shardedJedisPool) {
        this.dataSource = shardedJedisPool;
    }

    public void resetState() {
        for (Jedis jedis : this.getAllShards()) {
            jedis.resetState();
        }
    }

    public Long pfadd(String key, String ... elements) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pfadd(key, elements);
    }

    public long pfcount(String key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pfcount(key);
    }

    public Long geoadd(String key, double longitude, double latitude, String member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, longitude, latitude, member);
    }

    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, memberCoordinateMap);
    }

    public Long geoadd(String s, GeoAddParams geoAddParams, Map<String, GeoCoordinate> map) {
        return null;
    }

    public Double geodist(String key, String member1, String member2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geodist(key, member1, member2);
    }

    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geodist(key, member1, member2, unit);
    }

    public List<String> geohash(String key, String ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geohash(key, members);
    }

    public List<GeoCoordinate> geopos(String key, String ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geopos(key, members);
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadius(key, longitude, latitude, radius, unit);
    }

    public List<GeoRadiusResponse> georadiusReadonly(String s, double v, double v1, double v2, GeoUnit geoUnit) {
        Jedis j = (Jedis)this.getShard(s);
        return j.georadiusReadonly(s, v, v1, v2, geoUnit);
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadius(key, longitude, latitude, radius, unit, param);
    }

    public List<GeoRadiusResponse> georadiusReadonly(String s, double v, double v1, double v2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        Jedis j = (Jedis)this.getShard(s);
        return j.georadiusReadonly(s, v, v1, v2, geoUnit, geoRadiusParam);
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMember(key, member, radius, unit);
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String s, String s1, double v, GeoUnit geoUnit) {
        Jedis j = (Jedis)this.getShard(s);
        return j.georadiusByMemberReadonly(s, s1, v, geoUnit);
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMember(key, member, radius, unit, param);
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String s, String s1, double v, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        Jedis j = (Jedis)this.getShard(s);
        return j.georadiusByMemberReadonly(s, s1, v, geoUnit, geoRadiusParam);
    }

    public List<Long> bitfield(String key, String ... arguments) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitfield(key, arguments);
    }

    public List<Long> bitfieldReadonly(String s, String ... strings) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.bitfieldReadonly(s, strings);
    }

    public Long hstrlen(String s, String s1) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.hstrlen(s, s1);
    }

    public StreamEntryID xadd(String s, StreamEntryID streamEntryID, Map<String, String> map) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xadd(s, streamEntryID, map);
    }

    public StreamEntryID xadd(String s, StreamEntryID streamEntryID, Map<String, String> map, long l, boolean b) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xadd(s, streamEntryID, map, l, b);
    }

    public StreamEntryID xadd(String s, Map<String, String> map, XAddParams xAddParams) {
        return null;
    }

    public Long xlen(String s) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xlen(s);
    }

    public List<StreamEntry> xrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1) {
        return null;
    }

    public List<StreamEntry> xrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1, int i) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xrange(s, streamEntryID, streamEntryID1, i);
    }

    public List<StreamEntry> xrevrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1) {
        return null;
    }

    public List<StreamEntry> xrevrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1, int i) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xrevrange(s, streamEntryID, streamEntryID1, i);
    }

    public long xack(String s, String s1, StreamEntryID ... streamEntryIDS) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xack(s, s1, streamEntryIDS);
    }

    public String xgroupCreate(String s, String s1, StreamEntryID streamEntryID, boolean b) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xgroupCreate(s, s1, streamEntryID, b);
    }

    public String xgroupSetID(String s, String s1, StreamEntryID streamEntryID) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xgroupSetID(s, s1, streamEntryID);
    }

    public long xgroupDestroy(String s, String s1) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xgroupDestroy(s, s1);
    }

    public Long xgroupDelConsumer(String s, String s1, String s2) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xgroupDelConsumer(s, s1, s2);
    }

    public StreamPendingSummary xpending(String s, String s1) {
        return null;
    }

    public List<StreamPendingEntry> xpending(String s, String s1, StreamEntryID streamEntryID, StreamEntryID streamEntryID1, int i, String s2) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xpending(s, s1, streamEntryID, streamEntryID1, i, s2);
    }

    public List<StreamPendingEntry> xpending(String s, String s1, XPendingParams xPendingParams) {
        return null;
    }

    public long xdel(String s, StreamEntryID ... streamEntryIDS) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xdel(s, streamEntryIDS);
    }

    public long xtrim(String s, long l, boolean b) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xtrim(s, l, b);
    }

    public long xtrim(String s, XTrimParams xTrimParams) {
        return 0L;
    }

    public List<StreamEntry> xclaim(String s, String s1, String s2, long l, long l1, int i, boolean b, StreamEntryID ... streamEntryIDS) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xclaim(s, s1, s2, l, l1, i, b, streamEntryIDS);
    }

    public List<StreamEntry> xclaim(String s, String s1, String s2, long l, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDS) {
        return null;
    }

    public List<StreamEntryID> xclaimJustId(String s, String s1, String s2, long l, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDS) {
        return null;
    }

    public Map.Entry<StreamEntryID, List<StreamEntry>> xautoclaim(String s, String s1, String s2, long l, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        return null;
    }

    public Map.Entry<StreamEntryID, List<StreamEntryID>> xautoclaimJustId(String s, String s1, String s2, long l, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        return null;
    }

    public StreamInfo xinfoStream(String s) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xinfoStream(s);
    }

    public List<StreamGroupInfo> xinfoGroup(String s) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xinfoGroup(s);
    }

    public List<StreamConsumersInfo> xinfoConsumers(String s, String s1) {
        Jedis jedis = (Jedis)this.getShard(s);
        return jedis.xinfoConsumers(s, s1);
    }

    public LCSMatchResult strAlgoLCSStrings(String s, String s1, StrAlgoLCSParams strAlgoLCSParams) {
        return null;
    }

    public Object eval(String script, List<String> keys, List<String> args) {
        Jedis j = (Jedis)this.getShard(keys.get(0));
        return j.eval(script, keys, args);
    }

    public Object eval(byte[] script, byte[] keyCount, byte[] ... params) {
        Jedis j = (Jedis)this.getShard(params[0]);
        return j.eval(script, keyCount, params);
    }

    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        SetParams setParams = new SetParams();
        if (new String(nxxx).equalsIgnoreCase("nx")) {
            setParams.nx();
        } else if (new String(nxxx).equalsIgnoreCase("xx")) {
            setParams.xx();
        }
        if (new String(expx).equalsIgnoreCase("ex")) {
            setParams.ex((int)time);
        } else if (new String(expx).equalsIgnoreCase("px")) {
            setParams.px(time);
        }
        return this.set(key, value, setParams);
    }

    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        ListPosition n = Arrays.equals(where.raw, BinaryClient.LIST_POSITION.BEFORE.raw) ? ListPosition.BEFORE : ListPosition.AFTER;
        return this.linsert(key, n, pivot, value);
    }
}

