/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.cage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.cage.commons.CageException;
import kd.bos.cage.controller.CageThreadLifeCycleListener;
import kd.bos.cage.funswitch.CageSwitch;
import kd.bos.eye.api.cage.AbstractCageHandler;
import kd.bos.eye.api.cage.vo.CageSwitchInfo;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleListener;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class SwitchHandler
extends AbstractCageHandler {
    private static final Log log = LogFactory.getLog(SwitchHandler.class);
    private static final String DUPLICATE_APP_EXCEPTION_KEY_WORD = "Duplicate";
    private static final String PERCENT_SIGN = "%";
    private String nodeName;

    public static SwitchHandler getInstance() {
        return SingletonHolder.instance;
    }

    private SwitchHandler() {
        try {
            this.nodeName = "switch";
            super.setNodeName(this.nodeName);
            if (CageSwitch.cgroupRuntimeEnvIsOn()) {
                ThreadLifeCycleManager.addListener((ThreadLifeCycleListener)new CageThreadLifeCycleListener());
            }
            this.createZKListener();
            this.synCfgInfoToZK();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        boolean checkDB = super.checkStorageDBCfg(exchange, (ApiResponse<Object>)response);
        if (!checkDB) {
            return;
        }
        try {
            String requestType;
            CageSwitchInfo paramInfo = (CageSwitchInfo)ExchangeVueUtils.parseJsonFromPost((HttpExchange)exchange, CageSwitchInfo.class);
            switch (requestType = paramInfo.getRequestType()) {
                case "edit": {
                    this.updateSwitchStatus(paramInfo);
                    break;
                }
                case "del": {
                    this.deleteExcludeApp(paramInfo);
                    break;
                }
                case "add": {
                    this.addExcludeApp(paramInfo);
                    break;
                }
                case "querySwitch": {
                    this.returnMap.put("cageSwitch", this.querySwitchStatus());
                    break;
                }
                default: {
                    this.returnMap.put("cageConfigInfo", this.query(paramInfo));
                    response.setData((Object)this.returnMap);
                }
            }
            response.setData((Object)this.returnMap);
            response.setMsg("success");
        }
        catch (Exception e) {
            response.setCode(Integer.valueOf(0));
            if (e.getMessage().contains(DUPLICATE_APP_EXCEPTION_KEY_WORD)) {
                response.setMsg("appDuplicate");
            } else {
                response.setMsg("failure");
            }
            log.error("SwitchHandler exception", (Throwable)e);
        }
        this.writeJson(JSONUtils.toString((Object)response), exchange);
    }

    @Override
    JSONArray getConfigData() {
        JSONArray jsonArray = new JSONArray();
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fkey, fvalue from t_monitor_cage_switch";
        ArrayList queryList = new ArrayList(1);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List rows = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        for (Result row : rows) {
            JSONObject jsonObject = new JSONObject();
            String key = row.getString("fkey");
            String status = row.getString("fvalue");
            jsonObject.put("key", (Object)key);
            jsonObject.put("status", (Object)status);
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    private String querySwitchStatus() {
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> paramList = new ArrayList<String>(1);
        paramList.add("cageSwitch");
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(" select fvalue from t_monitor_cage_switch where fkey=? order by fupdatetime desc", paramList));
        List queryList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (!queryList.isEmpty()) {
            return ((Result)queryList.get(0)).getString("fvalue");
        }
        log.error("not find fkey='cageSwitch' record from t_monitor_cage_switch table!");
        throw new CageException("failure");
    }

    private List<String> query(CageSwitchInfo paramInfo) {
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> queryList = new ArrayList<String>(10);
        queryList.add("cageSwitch");
        if (StringUtils.isEmpty((String)paramInfo.getKey())) {
            dbRequest.setQueryRequest(new DBRequest.QueryRequest("select fkey from t_monitor_cage_switch where fkey !=? order by fupdatetime desc", queryList));
        } else {
            queryList.add(new StringBuffer(PERCENT_SIGN).append(paramInfo.getKey()).append(PERCENT_SIGN).toString());
            dbRequest.setQueryRequest(new DBRequest.QueryRequest("select fkey from t_monitor_cage_switch where  fkey !=? and fkey like ?  order by fupdatetime desc", queryList));
        }
        List list = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<String> appSwitchList = new ArrayList<String>();
        list.forEach(row -> appSwitchList.add(row.getString("fkey")));
        return appSwitchList;
    }

    private void updateSwitchStatus(CageSwitchInfo cageSwitchInfo) {
        try {
            DBRequest dbRequest = new DBRequest();
            ArrayList updateList = new ArrayList(1);
            Collections.addAll(updateList, cageSwitchInfo.getValue(), LocalDate.now(), cageSwitchInfo.getKey());
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest("update t_monitor_cage_switch set fvalue= ?,fupdatetime = ? where fkey = ?", updateList));
            if (0 < MetadataFactory.getStatement().executeUpdate((Request)dbRequest)) {
                this.synCfgInfoToZK();
            }
        }
        catch (Exception e) {
            throw new CageException("failure", (Throwable)e);
        }
    }

    private void addExcludeApp(CageSwitchInfo cageSwitchInfo) {
        DBRequest dbRequest = new DBRequest();
        String appName = cageSwitchInfo.getKey();
        ArrayList insertList = new ArrayList(5);
        Collections.addAll(insertList, ID.genLongId(), appName, "OFF", "", LocalDateTime.now());
        try {
            dbRequest.setInsertRequest(new DBRequest.InsertRequest("insert into t_monitor_cage_switch values(?,?,?,?,?)", insertList));
            if (0 < MetadataFactory.getStatement().executeInsert((Request)dbRequest)) {
                this.returnMap.put("cageConfigInfo", "success");
                this.synCfgInfoToZK();
            }
        }
        catch (Exception e) {
            String msg = e.getLocalizedMessage();
            if (msg.contains(DUPLICATE_APP_EXCEPTION_KEY_WORD)) {
                throw new CageException(DUPLICATE_APP_EXCEPTION_KEY_WORD, (Throwable)e);
            }
            throw new CageException("failure", (Throwable)e);
        }
    }

    private void deleteExcludeApp(CageSwitchInfo cageSwitchInfo) {
        DBRequest dbRequest = new DBRequest();
        String appName = cageSwitchInfo.getKey();
        ArrayList delList = new ArrayList(1);
        Collections.addAll(delList, appName);
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest("delete from  t_monitor_cage_switch where fkey = ?", delList));
        try {
            if (0 < MetadataFactory.getStatement().executeDelete((Request)dbRequest)) {
                this.synCfgInfoToZK();
            }
        }
        catch (Exception e) {
            throw new CageException(e.getMessage(), (Throwable)e);
        }
    }

    private static class SingletonHolder {
        private static final SwitchHandler instance = new SwitchHandler();

        private SingletonHolder() {
        }
    }
}

