/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.clustercheck;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.api.healthcheck.spi.HealthCheckConfig;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.mservice.monitor.ServiceInfoManger;
import kd.bos.util.StringUtils;

public class ClusterInfoHandler
implements HttpHandler,
EyeExtendedHandlerHolder {
    private static final ClusterInfoHandler instance = new ClusterInfoHandler();

    public String[] getPaths() {
        return new String[]{"/queryAppNames"};
    }

    public HttpHandler getHandler() {
        return instance;
    }

    public boolean isApiClose() {
        return true;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        JSONObject response = new JSONObject();
        try {
            JSONObject params = (JSONObject)ExchangeVueUtils.parseJsonFromPost((HttpExchange)httpExchange, JSONObject.class);
            if (this.auth(params)) {
                response.put("status", (Object)0);
                JSONObject jsonObject = new JSONObject();
                List serviceList = ServiceInfoManger.getInstance().getServiceList();
                ArrayList list = new ArrayList(serviceList.size());
                for (ServiceInfo serviceInfo : serviceList) {
                    HashMap<String, Object> temp = new HashMap<String, Object>(8);
                    temp.put("appName", serviceInfo.getAppName());
                    temp.put("instanceId", serviceInfo.getInstanceId());
                    temp.put("appIds", serviceInfo.getAppIds());
                    list.add(temp);
                }
                jsonObject.put("registedAppIds", (Object)System.getProperty("registedAppIds"));
                jsonObject.put("serviceInfo", list);
                response.put("msg", (Object)"success");
                response.put("data", (Object)jsonObject);
            } else {
                response.put("msg", (Object)"[ERROR] access denied,user and password doesn't match,please check monitor configuration ");
                response.put("status", (Object)-1);
            }
        }
        catch (Exception e) {
            response.put("msg", (Object)ExceptionHandler.getExceptionStackTrace((Throwable)e));
            response.put("status", (Object)-1);
        }
        this.writeJson(response.toJSONString(), httpExchange);
    }

    protected void writeJson(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    protected boolean auth(JSONObject params) {
        JSONObject auth = params.getJSONObject("auth");
        String userName = auth.getString("userName");
        String passwd = auth.getString("password");
        if (auth == null || StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)passwd)) {
            throw new IllegalArgumentException("auth message is null, access denied");
        }
        return HealthCheckConfig.checkAuth((String)userName, (String)Encrypters.decode((String)passwd));
    }
}

