/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.clustercheck;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.List;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.api.clustercheck.ClusterCheckHandler;
import kd.bos.eye.api.clustercheck.ClusterChecker;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.ExchangeVueUtils;

public class ServiceHealthHandler
extends ClusterCheckHandler
implements EyeExtendedHandlerHolder {
    private static final ServiceHealthHandler instance = new ServiceHealthHandler();

    @Override
    public String[] getPaths() {
        return new String[]{"/healthcheck/v2/service"};
    }

    @Override
    public HttpHandler getHandler() {
        return instance;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        JSONObject response;
        JSONObject params = (JSONObject)ExchangeVueUtils.parseJsonFromPost((HttpExchange)exchange, JSONObject.class);
        long start = System.currentTimeMillis();
        long timestamp = params.getJSONObject("params").getLongValue("timestamp");
        long cost = this.cost(timestamp);
        try {
            if (this.auth(params)) {
                response = this.ofResponse(0, "", 0L, cost);
                List<JSONObject> checkResults = ClusterChecker.getCheckResult();
                for (JSONObject checkResult : checkResults) {
                    checkResult.put("httpcost", (Object)cost);
                }
                response.put("result", checkResults);
            } else {
                response = this.ofResponse(-1, "[ERROR] access denied,user and password doesn't match,please check monitor configuration ", this.cost(start), cost);
            }
        }
        catch (Exception e) {
            response = this.ofResponse(-1, ExceptionHandler.getExceptionStackTrace((Throwable)e), this.cost(start), cost);
        }
        this.writeJson(response.toJSONString(), exchange);
    }
}

