/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dts.handle;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dts.business.DtsBusinessTypeFactory;
import kd.bos.dts.enmu.DtsDestTypeEnum;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.log.DateUtil;
import kd.bos.dts.log.DtsStatusQuery;
import kd.bos.dts.log.query.PageInfo;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class DtsExcInfoHanle
extends AbstractHttpHandler
implements EyeExtendedHandlerHolder {
    private static final Log LOGGER = LogFactory.getLog(DtsExcInfoHanle.class);
    private static final DtsExcInfoHanle instance = new DtsExcInfoHanle();

    public String[] getPaths() {
        return new String[]{"/eye/excInfo/", "/eye/excInfo"};
    }

    public HttpHandler getHandler() {
        return instance;
    }

    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(2);
        try {
            Map params = EyeUriQuery.toMap((String)exchange.getRequestURI().getQuery());
            int page = StringUtils.isEmpty((String)((String)params.get("page"))) ? 1 : Integer.parseInt((String)params.get("page"));
            int size = StringUtils.isEmpty((String)((String)params.get("size"))) ? 100 : Integer.parseInt((String)params.get("size"));
            String account = (String)params.get("account");
            String number = (String)params.get("number");
            String beginTimeStr = (String)params.get("beginTime");
            String endTimeStr = (String)params.get("endTime");
            Date beginTime = null;
            Date endTime = null;
            if (StringUtils.isNotEmpty((String)beginTimeStr) && StringUtils.isNotEmpty((String)endTimeStr)) {
                beginTime = DateUtil.utcDateToDate((String)beginTimeStr);
                endTime = DateUtil.utcDateToDate((String)endTimeStr);
                beginTime = DateUtil.addHours((Date)beginTime, (int)8);
                endTime = DateUtil.addHours((Date)endTime, (int)8);
            }
            PageInfo pageInfo = DtsStatusQuery.get().queryStatusExceptionList(account, number, null, beginTime, endTime, page, size);
            for (Map mp : pageInfo.getList()) {
                mp.put("destination_type", DtsDestTypeEnum.from((String)((String)mp.get("destination_type"))).getValue());
                mp.put("businesstype", DtsBusinessTypeFactory.getName((String)((String)mp.get("businesstype"))));
                mp.put("dts_timestap", DateUtil.utcDateToString((String)((String)mp.get("dts_timestap"))));
            }
            response.put("code", 0);
            response.put("data", pageInfo);
            response.put("entityNumbers", this.queryEntityNumberSet());
        }
        catch (Exception e) {
            LOGGER.error("query dts exception info error: ", (Throwable)e);
            response.put("code", -1);
            response.put("errorMsg", e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private Set<String> queryEntityNumberSet() {
        HashSet<String> retSet = new HashSet<String>(8);
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        accounts.forEach(account -> {
            ThreadLifeCycleManager.start();
            RequestContext context = RequestContext.create();
            context.setAccountId(account.getAccountId());
            context.setTenantId(account.getTenantId());
            try {
                if (DtsAccountPower.isAccountDtsEnable()) {
                    Set entityNumberSet = DtsSnapConfigDao.instance.getEntityNumberSet();
                    retSet.addAll(entityNumberSet);
                }
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        });
        return retSet;
    }
}

