/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dts.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.api.mq.MqMgr;
import kd.bos.eye.api.mq.rabbit.ConfigPicker;
import kd.bos.eye.api.mq.rabbit.RabbitRestTool;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;

public class DtsMqHandel
extends AbstractHttpHandler
implements EyeExtendedHandlerHolder {
    private static final Log LOGGER = LogFactory.getLog(DtsMqHandel.class);
    private static ExtensionFactory<MqMgr> mqMgrExtensionFactory = ExtensionFactory.getExtensionFacotry(MqMgr.class);
    private static final String V_HOST = "vhost";
    private static final String PAGE_SIZE = "page_size";
    private static final DtsMqHandel instance = new DtsMqHandel();

    public String[] getPaths() {
        return new String[]{"/eye/dtsMq/", "/eye/dtsMq"};
    }

    public HttpHandler getHandler() {
        return instance;
    }

    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(3);
        try {
            String property = System.getProperty("mq.server");
            Properties prop = new Properties();
            StringReader reader = new StringReader(property);
            prop.load(reader);
            String mqType = prop.getProperty("type");
            if (!"rabbitmq".equalsIgnoreCase(mqType)) {
                response.put("code", -1);
                response.put("msg", LangRes.get("DtsMQTips", "Not support {0}", mqType));
                String str = JSONUtils.toString(response);
                this.writeJson(str, exchange);
                return;
            }
            String vhost = prop.getProperty(V_HOST);
            Map params = EyeUriQuery.toMap((String)exchange.getRequestURI().getQuery());
            params.put(V_HOST, vhost);
            JSONObject json = JSON.parseObject((String)this.buildJson(this.getMqInfo(this.getApi(params))));
            json.put(V_HOST, (Object)vhost);
            response.put("data", json);
            response.put("code", 0);
        }
        catch (Exception e) {
            LOGGER.error("query dts mq info error: ", (Throwable)e);
            response.put("code", -1);
            response.put("msg", e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private String getApi(Map<String, String> params) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/api/queues/");
        stringBuilder.append(params.get(V_HOST));
        if (!Objects.isNull(params.get("queue_name"))) {
            stringBuilder.append("/");
            stringBuilder.append(params.get("queue_name"));
            return stringBuilder.toString();
        }
        stringBuilder.append("?page=");
        stringBuilder.append(params.get("page"));
        stringBuilder.append("&page_size=");
        stringBuilder.append(params.get(PAGE_SIZE));
        stringBuilder.append("&name=dts");
        return stringBuilder.toString();
    }

    private JSONObject getMqInfo(String apiUrl) {
        ConfigPicker configPicker = new ConfigPicker();
        String host = configPicker.getHost();
        String user = configPicker.getUser();
        String pwd = configPicker.getPassword();
        int webPort = Integer.parseInt(configPicker.getWebPort());
        String result = null;
        try {
            result = RabbitRestTool.getRestfulResult(host, webPort, apiUrl, user, pwd);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqConfiguration, new Object[]{e.getMessage()});
        }
        return JSONObject.parseObject((String)result);
    }

    private JSONObject getQueueConsume(String vhost, String queName) {
        String apiUrl = "/api/queues/" + vhost + "/" + queName;
        return this.getMqInfo(apiUrl);
    }

    private String buildJson(JSONObject result) {
        String item_count = result.getString("item_count");
        String total_count = result.getString("total_count");
        String page_count = result.getString("page_count");
        String page_size = result.getString(PAGE_SIZE);
        String filtered_count = result.getString("filtered_count");
        JSONArray itemsArray = result.getJSONArray("items");
        JSONObject nobject = new JSONObject();
        nobject.put("item_count", (Object)item_count);
        nobject.put("total_count", (Object)total_count);
        nobject.put("page_count", (Object)page_count);
        nobject.put(PAGE_SIZE, (Object)page_size);
        nobject.put("filtered_count", (Object)filtered_count);
        JSONArray nArray = new JSONArray();
        for (int i = 0; i < itemsArray.size(); ++i) {
            JSONObject queueitem = (JSONObject)itemsArray.get(i);
            String total = queueitem.getString("messages");
            String messages_ready = queueitem.getString("messages_ready");
            String messages_unacknowledged = queueitem.getString("messages_unacknowledged");
            String vhost = queueitem.getString(V_HOST);
            String name = queueitem.getString("name");
            String state = queueitem.getString("state");
            JSONObject nitem = new JSONObject();
            nitem.put("name", (Object)name);
            nitem.put("total", (Object)total);
            nitem.put("ready", (Object)messages_ready);
            nitem.put("unacknowledged", (Object)messages_unacknowledged);
            nitem.put(V_HOST, (Object)vhost);
            nitem.put("state", (Object)state);
            this.setQueuesConsumer(nitem, vhost, name);
            nArray.add((Object)nitem);
        }
        nobject.put("items", (Object)nArray);
        return nobject.toJSONString();
    }

    private void setQueuesConsumer(JSONObject nitem, String vhost, String name) {
        JSONObject result = this.getQueueConsume(vhost, name);
        if (result.getJSONArray("consumer_details").isEmpty()) {
            nitem.put("consumer", (Object)"no");
            return;
        }
        JSONArray itemsArray = result.getJSONArray("consumer_details");
        JSONObject detail = (JSONObject)itemsArray.get(0);
        String tag = detail.getString("consumer_tag");
        JSONObject channel = detail.getJSONObject("channel_details");
        String ip = channel.getString("peer_host");
        String port = channel.getString("peer_port");
        nitem.put("consumer", (Object)(ip + ":" + port + "@" + tag));
    }
}

