/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dts.handle;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.service.DtsMQueueDefManager;
import kd.bos.dts.service.DtsService;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.dts.master.ElectorMaster;
import kd.bos.eye.api.dts.vo.DtsAccountVO;
import kd.bos.eye.api.dts.vo.DtsAllInfoVO;
import kd.bos.eye.api.dts.vo.DtsAppVO;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.service.EyeServerService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.JSONUtils;

public class DtsNodeHandel
extends AbstractHttpHandler
implements EyeExtendedHandlerHolder {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private final Charset charset = Charset.forName("UTF-8");
    private static final Log LOGGER = LogFactory.getLog(DtsNodeHandel.class);
    private static final DtsNodeHandel instance = new DtsNodeHandel();

    public String[] getPaths() {
        return new String[]{"/eye/dtsNode/", "/eye/dtsNode"};
    }

    public HttpHandler getHandler() {
        return instance;
    }

    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(3);
        DtsAllInfoVO allInfoVO = new DtsAllInfoVO();
        allInfoVO.setIsEnable(DtsUtils.dtsEnable());
        allInfoVO.setDtsRunAppid(DtsService.DTS_RUNNING_APPID);
        allInfoVO.setBizRunEnable(DtsUtils.dtsBizRunEnable());
        allInfoVO.setDtsAccountVOS(this.getEnableAccounts());
        response.put("code", 0);
        try {
            allInfoVO.setDtsAppVOS(this.getDtsAppList(allInfoVO.getDtsRunAppid()));
            response.put("data", allInfoVO);
        }
        catch (Exception e) {
            LOGGER.error("query dts node error: ", (Throwable)e);
            response.put("code", -1);
            response.put("errorMsg", e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private List<DtsAppVO> getDtsAppList(String appId) {
        ArrayList<DtsAppVO> dtsAppVOList = new ArrayList<DtsAppVO>(4);
        Map<String, Set<String>> masterAppidsMap = this.getMasters();
        HashSet<String> masterIds = new HashSet<String>(3);
        HashSet appIds = new HashSet(3);
        for (Map.Entry<String, Set<String>> entry : masterAppidsMap.entrySet()) {
            masterIds.add(entry.getKey());
            appIds.addAll(entry.getValue());
        }
        List<Object> serverNodes = this.getSortedNodeInfos();
        if (Instance.isAppSplit() && !DtsUtils.dtsBizRunEnable()) {
            serverNodes = serverNodes.stream().filter(o -> ArrayUtils.contains((Object[])o.getAppIds(), (Object)appId)).collect(Collectors.toList());
        }
        if (DtsUtils.dtsBizRunEnable()) {
            serverNodes = serverNodes.stream().filter(o -> DtsNodeHandel.containsOneof(o.getAppIds(), appIds)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(serverNodes)) {
            return dtsAppVOList;
        }
        for (EyeNodeInfo nodeInfo : serverNodes) {
            DtsAppVO dtsAppVO = new DtsAppVO();
            dtsAppVO.setAppIds(nodeInfo.getAppIds());
            dtsAppVO.setHostIp(nodeInfo.getHostIp());
            dtsAppVO.setPort(nodeInfo.getMonitorPort());
            dtsAppVO.setInstanceId(nodeInfo.getInstanceId());
            if (masterIds.contains(nodeInfo.getInstanceId())) {
                dtsAppVO.setIsMaster(1);
                Set<String> appids = masterAppidsMap.get(nodeInfo.getInstanceId());
                dtsAppVO.setDtsRunAppids(DtsNodeHandel.joinArray(appids.toArray(new String[appids.size()]), ","));
            } else {
                dtsAppVO.setIsMaster(0);
            }
            dtsAppVO.setStartTime(nodeInfo.getStartTime());
            dtsAppVOList.add(dtsAppVO);
        }
        Collections.sort(dtsAppVOList, Comparator.comparing(DtsAppVO::getIsMaster).reversed());
        return dtsAppVOList;
    }

    private Map<String, Set<String>> getMasters() {
        Set<String> dtsAppids = new HashSet<String>(2);
        if (DtsUtils.dtsBizRunEnable()) {
            dtsAppids = DtsMQueueDefManager.getDtsAppids();
            dtsAppids.add(DtsService.DTS_RUNNING_APPID);
        } else {
            dtsAppids.add(DtsService.DTS_RUNNING_APPID);
        }
        HashMap<String, Set<String>> masterAppidsMap = new HashMap<String, Set<String>>(3);
        for (String appid : dtsAppids) {
            String instanceId = ElectorMaster.getMasterByAppId(appid);
            if (instanceId == null) continue;
            HashSet<String> appids = (HashSet<String>)masterAppidsMap.get(instanceId);
            if (appids == null) {
                appids = new HashSet<String>(2);
                masterAppidsMap.put(instanceId, appids);
            }
            if (appid.equalsIgnoreCase(DtsService.DTS_RUNNING_APPID)) {
                appids.add("dts");
                continue;
            }
            appids.add(appid);
        }
        return masterAppidsMap;
    }

    private static String joinArray(String[] array, String delim) {
        StringBuilder sb = new StringBuilder();
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    private static boolean containsOneof(Object[] array, Set<String> objectToFindArray) {
        for (String objectToFind : objectToFindArray) {
            if (ArrayUtils.indexOf((Object[])array, (Object)objectToFind) == -1) continue;
            return true;
        }
        return false;
    }

    private List<EyeNodeInfo> getSortedNodeInfos() {
        return EyeServerService.getAllEyeNodes();
    }

    private List<DtsAccountVO> getEnableAccounts() {
        ArrayList<DtsAccountVO> dtsAccountDTOS = new ArrayList<DtsAccountVO>();
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        accounts.forEach(account -> {
            ThreadLifeCycleManager.start();
            RequestContext context = RequestContext.create();
            context.setAccountId(account.getAccountId());
            context.setTenantId(account.getTenantId());
            try {
                if (DtsAccountPower.isAccountDtsEnable()) {
                    DtsAccountVO dtsAccountDTO = new DtsAccountVO();
                    dtsAccountDTO.setAccountId(account.getAccountId());
                    dtsAccountDTO.setAccountName(account.getAccountName());
                    dtsAccountDTO.setTenantId(account.getTenantId());
                    dtsAccountDTOS.add(dtsAccountDTO);
                }
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        });
        return dtsAccountDTOS;
    }
}

