/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dts.handle;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dts.log.DateUtil;
import kd.bos.dts.log.DtsStatusQuery;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class SyncDetailHandel
extends AbstractHttpHandler
implements EyeExtendedHandlerHolder {
    private static final Log LOGGER = LogFactory.getLog(SyncDetailHandel.class);
    private static final SyncDetailHandel instance = new SyncDetailHandel();

    public String[] getPaths() {
        return new String[]{"/eye/syncDetail/", "/eye/syncDetail"};
    }

    public HttpHandler getHandler() {
        return instance;
    }

    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(2);
        try {
            Map params = EyeUriQuery.toMap((String)exchange.getRequestURI().getQuery());
            String beginTimeStr = (String)params.get("beginTime");
            String endTimeStr = (String)params.get("endTime");
            String accountId = (String)params.get("account");
            Date beginTime = null;
            Date endTime = null;
            if (StringUtils.isNotEmpty((String)beginTimeStr) && StringUtils.isNotEmpty((String)endTimeStr)) {
                beginTime = DateUtil.utcDateToDate((String)beginTimeStr);
                endTime = DateUtil.utcDateToDate((String)endTimeStr);
                beginTime = DateUtil.addHours((Date)beginTime, (int)8);
                endTime = DateUtil.addHours((Date)endTime, (int)8);
            }
            response.put("code", 0);
            List maps = DtsStatusQuery.get().queryCountsGroupByAccount(accountId, beginTime, endTime);
            for (Map mp : maps) {
                mp.put("timestamp", DateUtil.utcDateToString((String)((String)mp.get("timestamp"))));
            }
            response.put("data", maps);
        }
        catch (Exception e) {
            LOGGER.error("query dts sync detail error: ", (Throwable)e);
            response.put("code", -1);
            response.put("errorMsg", e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }
}

