/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.healthcheck.spi.component;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.eye.api.healthcheck.spi.CheckResult;
import kd.bos.eye.api.healthcheck.spi.HealthCheck;
import kd.bos.eye.api.healthcheck.spi.component.ComponentCheckResult;
import kd.bos.mq.support.QueueManager;
import kd.bos.rabbitmq.RabbitmqFactory;

public class MqServerCheckExecutor
implements HealthCheck {
    public List<CheckResult> check() {
        Map<String, Object> mqConfig = this.getMQConfig();
        ArrayList<CheckResult> results = new ArrayList<CheckResult>(mqConfig.size());
        for (Map.Entry<String, Object> next : mqConfig.entrySet()) {
            String key = next.getKey();
            long start = System.currentTimeMillis();
            try (Connection connection = RabbitmqFactory.getConnection((String)key);
                 Channel channel = connection.createChannel();){
                String queueName = QueueManager.getRealQueueName((String)"demo", (String)"demo_queue");
                channel.basicPublish("", queueName, null, "speed test".getBytes());
            }
            catch (Exception e) {
                results.add(ComponentCheckResult.error((String)key, (String)"MQ", (String)("send message to mq server exception, exception massage: " + e.getMessage())));
                continue;
            }
            long eclipseTime = System.currentTimeMillis() - start;
            CheckResult result = ComponentCheckResult.ofResult((String)key, (String)"MQ", (String)String.format("check cost time: %d ms", eclipseTime), (int)HealthCheck.getLevel((long)eclipseTime));
            results.add(result);
        }
        return results;
    }

    private Map<String, Object> getMQConfig() {
        Properties properties = System.getProperties();
        HashMap<String, Object> retMap = new HashMap<String, Object>(4);
        for (Map.Entry<Object, Object> next : properties.entrySet()) {
            String key = next.getKey().toString();
            if (!key.startsWith("mq.server")) continue;
            retMap.put(key, next.getValue());
        }
        return retMap;
    }
}

