/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq.pigeon;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.eye.api.mq.pigeon.vo.PigeonQueueCountVO;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.StoreDbConfigFactory;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.store.db.statistics.QueueMessageStatistics;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.dispatch.support.DispatchExecutionEnvironmentService;

public abstract class AbstractPigeonHandler
extends AbstractHttpHandler {
    protected Map<String, PigeonQueueCountVO> countStatus(String queueName) {
        HashMap<String, PigeonQueueCountVO> queue2countVOMap = new HashMap<String, PigeonQueueCountVO>(256);
        for (DispatchExecutionEnvironmentService tempEnvironmentService : ServiceLoader.load(DispatchExecutionEnvironmentService.class)) {
            String tempBizType = tempEnvironmentService.bizType();
            IStoreDbConfig storeDbConfig = StoreDbConfigFactory.getDbConfigByBizType((String)tempBizType);
            List statisticsList = QueueMessageEntityHelper.countStatus((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, (String)queueName);
            for (QueueMessageStatistics tempStatistics : statisticsList) {
                String tempQueueName = tempStatistics.getQueueName();
                int tempCount = tempStatistics.getCountSize();
                String status = tempStatistics.getStatus();
                PigeonQueueCountVO pigeonQueueCountVO = queue2countVOMap.computeIfAbsent(tempQueueName, key -> new PigeonQueueCountVO(tempQueueName));
                pigeonQueueCountVO.setBizType(tempBizType);
                if (status.equals(MessageStatus.READY.getDesc())) {
                    pigeonQueueCountVO.setReady(tempCount);
                    continue;
                }
                if (status.equals(MessageStatus.RECEIVED.getDesc())) {
                    pigeonQueueCountVO.setReceived(tempCount);
                    continue;
                }
                if (status.equals(MessageStatus.RUNNING.getDesc())) {
                    pigeonQueueCountVO.setRunning(tempCount);
                    continue;
                }
                if (status.equals(MessageStatus.SUCCESS.getDesc())) {
                    pigeonQueueCountVO.setSuccess(tempCount);
                    continue;
                }
                if (status.equals(MessageStatus.RETRY.getDesc())) {
                    pigeonQueueCountVO.setRetry(tempCount);
                    continue;
                }
                if (status.equals(MessageStatus.DISCARD.getDesc())) {
                    pigeonQueueCountVO.setDiscard(tempCount);
                    continue;
                }
                if (!status.equals(MessageStatus.FAILED.getDesc())) continue;
                pigeonQueueCountVO.setFailed(tempCount);
            }
        }
        return queue2countVOMap;
    }
}

