/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq.pigeon;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.mq.pigeon.AbstractPigeonHandler;
import kd.bos.eye.api.mq.pigeon.vo.PigeonSimpleAccountVO;
import kd.bos.eye.api.mq.pigeon.vo.PigeonSimpleAccountVOWrapper;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.failover.FailoverConfig;
import kd.bos.mq.support.QueueManager;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.util.JSONUtils;

public class PigeonEnvHandler
extends AbstractPigeonHandler {
    private static final Log LOGGER = LogFactory.getLog(PigeonEnvHandler.class);
    private static final String PLACEHOLDER = "/env/";

    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        response.setCode(Integer.valueOf(-1));
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        response.setData(map);
        try {
            String endPoint;
            Map params = EyeUriQuery.toMap((String)exchange.getRequestURI().getRawQuery());
            URI uri = exchange.getRequestURI();
            String reqPath = uri.getPath();
            int pos = reqPath.indexOf(PLACEHOLDER);
            switch (endPoint = reqPath.substring(pos + PLACEHOLDER.length())) {
                case "enable": {
                    String region = "NotExistRegion##@@!!";
                    String mqType = "";
                    mqType = FailoverConfig.MQ_FAILOVER_ENABLE ? FailoverConfig.getMQType((String)region) : QueueManager.getMQType((String)region);
                    if (mqType != null && !mqType.equals("pigeon")) {
                        response.setMsg("MQ monitor not support:" + mqType);
                        map.put("enable", false);
                    } else {
                        map.put("enable", true);
                    }
                    response.setCode(Integer.valueOf(0));
                    break;
                }
                case "accountInfo": {
                    List allAccountsOfCurrentEnv = AccountUtils.getAllAccountsOfCurrentEnv();
                    HashMap<String, List> tenantId2accountListMap = new HashMap<String, List>(4);
                    for (Object tempAccount : allAccountsOfCurrentEnv) {
                        List list = tenantId2accountListMap.computeIfAbsent(tempAccount.getTenantId(), key -> new ArrayList());
                        PigeonSimpleAccountVO simpleAccountVO = new PigeonSimpleAccountVO();
                        simpleAccountVO.setTenantId(tempAccount.getTenantId());
                        simpleAccountVO.setAccountId(tempAccount.getAccountId());
                        simpleAccountVO.setAccountName(tempAccount.getAccountName());
                        simpleAccountVO.setAccountNumber(tempAccount.getAccountNumber());
                        list.add(simpleAccountVO);
                    }
                    ArrayList<PigeonSimpleAccountVOWrapper> simpleAccountWrapperList = new ArrayList<PigeonSimpleAccountVOWrapper>(tenantId2accountListMap.size());
                    for (Map.Entry entry : tenantId2accountListMap.entrySet()) {
                        simpleAccountWrapperList.add(new PigeonSimpleAccountVOWrapper((String)entry.getKey(), (List)entry.getValue()));
                    }
                    map.put("accountInfo", simpleAccountWrapperList);
                    response.setCode(Integer.valueOf(0));
                    break;
                }
                case "statusList": {
                    MessageStatus[] values = MessageStatus.values();
                    map.put("statusList", values);
                    response.setCode(Integer.valueOf(0));
                    break;
                }
            }
        }
        catch (Exception e) {
            response.setCode(Integer.valueOf(-1));
            response.setMsg("PigeonEnvHandler exception, message: " + e.getMessage());
            LOGGER.error("PigeonEnvHandler exception, message: " + e);
        }
        String str = JSONUtils.toString((Object)response);
        this.writeJson(str, exchange);
    }
}

