/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq.rabbit;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import kd.bos.encrypt.Encrypters;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class RabbitRestTool {
    public static String getRestfulResult(String hostip, int port, String api, String u, String p) throws IOException {
        HttpHost host = new HttpHost(hostip, port);
        HttpGet httpGet = new HttpGet(api);
        String decode = Encrypters.decode((String)p);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(hostip, port), (Credentials)new UsernamePasswordCredentials(u, decode));
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        HttpResponse response = client.execute(host, (HttpRequest)httpGet);
        HttpEntity entity = response.getEntity();
        String s = EntityUtils.toString((HttpEntity)entity);
        return s;
    }

    public static String deleteRestfulResult(String hostip, int port, String api, String u, String p) throws IOException {
        HttpHost host = new HttpHost(hostip, port);
        HttpDelete httpGet = new HttpDelete(api);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(hostip, port), (Credentials)new UsernamePasswordCredentials(u, p));
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        HttpResponse response = client.execute(host, (HttpRequest)httpGet);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String s = EntityUtils.toString((HttpEntity)entity);
            return s;
        }
        return "{\"result\":\"success\"}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHttpsRestfulResult(HttpRequestBase method, boolean isHttpsEnable, boolean isCertificateEnable, String username, String password, String keystorePath, String keystorePassword, String trustStorePath, String trustStorePassword) throws Exception {
        try (CloseableHttpClient httpClient = null;){
            CloseableHttpResponse response;
            HttpEntity entity;
            int timeout = Integer.getInteger("eye.mq.api.timeout", 60000);
            HttpClientBuilder builder = HttpClients.custom();
            builder.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).setConnectionRequestTimeout(timeout).build());
            if (StringUtils.isNotEmpty((String)username)) {
                builder.setDefaultCredentialsProvider(RabbitRestTool.getCredentialsProvider(username, password));
            }
            if (isHttpsEnable) {
                SSLContext sslContext = isCertificateEnable ? SSLContexts.custom().loadKeyMaterial(RabbitRestTool.getKeyStore(keystorePath, keystorePassword), keystorePassword.toCharArray()).loadTrustMaterial(RabbitRestTool.getTrustStore(trustStorePath, trustStorePassword), (chain, authType) -> true).build() : SSLContexts.custom().loadTrustMaterial(null, (chain, authType) -> true).build();
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
            }
            if ((entity = (response = (httpClient = builder.build()).execute((HttpUriRequest)method)).getEntity()) != null) {
                String string = EntityUtils.toString((HttpEntity)entity);
                return string;
            }
            String string = "{\"result\":\"success\"}";
            return string;
        }
    }

    private static KeyStore getKeyStore(String keyStorePath, String keyStorePassword) throws Exception {
        try (FileInputStream keyStoreFile = new FileInputStream(keyStorePath);){
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(keyStoreFile, keyStorePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    private static KeyStore getTrustStore(String trustStorePath, String trustStorePassword) throws Exception {
        try (FileInputStream trustStoreFile = new FileInputStream(trustStorePath);){
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(trustStoreFile, trustStorePassword.toCharArray());
            KeyStore keyStore = trustStore;
            return keyStore;
        }
    }

    private static CredentialsProvider getCredentialsProvider(String username, String password) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return provider;
    }
}

