/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq.rabbit.processor;

import java.util.Objects;
import kd.bos.eye.api.mq.rabbit.ConfigPicker;
import kd.bos.eye.api.mq.rabbit.RabbitRestTool;
import kd.bos.eye.api.mq.rabbit.RabbitmqAction;
import kd.bos.eye.api.mq.rabbit.processor.RabbitmqActionProcessor;
import kd.bos.util.FileUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public abstract class AbstractRabbitmqActionProcessor
implements RabbitmqActionProcessor<String> {
    abstract String getApi(RabbitmqAction var1);

    abstract String buildJson(String var1);

    @Override
    public String process(RabbitmqAction mqAction) {
        ConfigPicker cp = new ConfigPicker();
        String host = cp.getHost();
        String user = cp.getUser();
        String password = cp.getPassword();
        int webPort = Integer.parseInt(cp.getWebPort());
        try {
            String response = this.invoke(cp, user, password, host, webPort, mqAction);
            return this.buildJson(response);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected final String invoke(ConfigPicker cp, String user, String password, String host, int webPort, RabbitmqAction mqAction) throws Exception {
        String response;
        String clientPath = null;
        String trustPath = null;
        String sslClientPassword = null;
        String sslTrustStorePassword = null;
        if (cp.isWebSSLenable()) {
            if (cp.isWebCertificateEnable()) {
                clientPath = FileUtils.checkFileUrl((String)Objects.requireNonNull(cp.getClientPath(), "ssl.certificate.clientPath can't be empty."));
                trustPath = FileUtils.checkFileUrl((String)Objects.requireNonNull(cp.getTrustPath(), "ssl.certificate.trustPath can't be empty."));
                sslClientPassword = Objects.requireNonNull(cp.getSSLClientPassword(), "ssl.certificate.keyPassword can't be empty.");
                sslTrustStorePassword = Objects.requireNonNull(cp.getSSLTrustStorePassword(), "ssl.certificate.trustPassword can't be empty.");
            }
            HttpGet get = new HttpGet("https://" + host + ":" + webPort + this.getApi(mqAction));
            response = RabbitRestTool.getHttpsRestfulResult((HttpRequestBase)get, cp.isWebSSLenable(), cp.isWebCertificateEnable(), user, password, clientPath, sslClientPassword, trustPath, sslTrustStorePassword);
        } else {
            response = RabbitRestTool.getRestfulResult(host, webPort, this.getApi(mqAction), user, password);
        }
        return response;
    }
}

