/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.mq.rocketmq.handler;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.mq.MqMgr;
import kd.bos.eye.api.mq.rocketmq.vo.RocketmqConsumerDataVO;
import kd.bos.eye.api.mq.rocketmq.vo.RocketmqListDataVO;
import kd.bos.eye.api.mq.rocketmq.vo.RocketmqStatusDataVO;
import kd.bos.eye.api.mq.support.vo.MqConsumerDataVO;
import kd.bos.eye.api.mq.support.vo.MqConsumerVO;
import kd.bos.eye.api.mq.support.vo.MqEyeMeta;
import kd.bos.eye.api.mq.support.vo.MqFieldVO;
import kd.bos.eye.api.mq.support.vo.MqListDataVO;
import kd.bos.eye.api.mq.support.vo.MqListVO;
import kd.bos.eye.api.mq.support.vo.MqStatusDataVO;
import kd.bos.eye.api.mq.support.vo.MqStatusVO;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.rocket.RocketMQTopicUtil;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.admin.ConsumeStats;
import org.apache.rocketmq.common.admin.OffsetWrapper;
import org.apache.rocketmq.common.admin.TopicOffset;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.Connection;
import org.apache.rocketmq.common.protocol.body.ConsumerConnection;
import org.apache.rocketmq.common.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.common.protocol.body.GroupList;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;

public class RocketmqMgrHandler
implements MqMgr {
    private static final Log LOGGER = LogFactory.getLog(RocketmqMgrHandler.class);
    private DefaultMQProducer defaultMQProducer;

    @Override
    public MqEyeMeta getMqMeta() {
        MqEyeMeta mqEyeMeta = new MqEyeMeta();
        mqEyeMeta.setMqType("rocketmq");
        mqEyeMeta.setApiNewVersion(true);
        mqEyeMeta.setApiPage(false);
        mqEyeMeta.setQueueFields(Collections.singletonList(new MqFieldVO("topic", LangRes.get("RocketmqMgrHandler_3", "Topic", new Object[0]))));
        mqEyeMeta.setOperations(Arrays.asList(new MqFieldVO("status", LangRes.get("RocketmqMgrHandler_1", "Status", new Object[0])), new MqFieldVO("consumers", LangRes.get("RocketmqMgrHandler_2", "Consumer", new Object[0]))));
        return mqEyeMeta;
    }

    private DefaultMQAdminExt getMQAdmin() {
        RocketInfo rocketInfo = this.getRocketInfo();
        RPCHook rpcHook = ProducerFactory.getAclRPCHook((String)rocketInfo.getUsername(), (String)rocketInfo.getPassword());
        try {
            return RocketMQTopicUtil.getAdminExt((RocketInfo)rocketInfo, (RPCHook)rpcHook);
        }
        catch (MQClientException e) {
            LOGGER.error("error when RocketmqMgrHandler getMQAdmin:", (Throwable)e);
            throw new KDException(BosErrorCode.rocketmqException, "error when RocketmqMgrHandler getMQAdmin", (Throwable)e);
        }
    }

    private RocketInfo getRocketInfo() {
        return RocketmqFactory.getRocketInfo((String)"mq.server");
    }

    @Override
    public MqListVO queueList(Map<String, String> params) {
        MqListVO mqListVO = new MqListVO();
        DefaultMQAdminExt mqAdmin = this.getMQAdmin();
        if (mqAdmin == null) {
            return mqListVO;
        }
        TopicList topicList = this.fetchAllTopicList(true, false, params.getOrDefault("name", ""), mqListVO);
        Set topicSet = topicList.getTopicList();
        ArrayList<MqListDataVO> mqListDataVOList = new ArrayList<MqListDataVO>(topicSet.size());
        for (String tempTopic : topicSet) {
            mqListDataVOList.add(new RocketmqListDataVO(tempTopic));
        }
        mqListVO.setItems(mqListDataVOList);
        int filteredCount = topicSet.size();
        mqListVO.setFiltered_count(filteredCount);
        int pageSize = Integer.parseInt(params.get("page_size"));
        mqListVO.setPage_size(pageSize);
        int pageCount = filteredCount / pageSize + (filteredCount % pageSize == 0 ? 0 : 1);
        mqListVO.setPage_count(pageCount);
        int itemCount = filteredCount;
        mqListVO.setItem_count(itemCount);
        return mqListVO;
    }

    @Override
    public MqStatusVO status(String topic) {
        MqStatusVO mqStatusVO = new MqStatusVO(topic);
        ArrayList<MqFieldVO> statusFields = new ArrayList<MqFieldVO>();
        statusFields.add(new MqFieldVO("queue", LangRes.get("RocketmqMgrHandler_4", "Queue", new Object[0])));
        statusFields.add(new MqFieldVO("minOffset", LangRes.get("RocketmqMgrHandler_5", "Min Offset", new Object[0])));
        statusFields.add(new MqFieldVO("maxOffset", LangRes.get("RocketmqMgrHandler_6", "Max Offset", new Object[0])));
        statusFields.add(new MqFieldVO("lastUpdateTimeStamp", LangRes.get("RocketmqMgrHandler_7", "Last Update Time", new Object[0])));
        mqStatusVO.setStatusFields(statusFields);
        DefaultMQAdminExt mqAdmin = this.getMQAdmin();
        if (mqAdmin == null) {
            return mqStatusVO;
        }
        try {
            TopicStatsTable topicStatsTable = mqAdmin.examineTopicStats(topic);
            HashMap offsetTable = topicStatsTable.getOffsetTable();
            ArrayList<MqStatusDataVO> statusDataVOList = new ArrayList<MqStatusDataVO>(offsetTable.size());
            for (Map.Entry tempEntry : offsetTable.entrySet()) {
                MessageQueue messageQueue = (MessageQueue)tempEntry.getKey();
                TopicOffset topicOffset = (TopicOffset)tempEntry.getValue();
                RocketmqStatusDataVO mqStatusDataVO = new RocketmqStatusDataVO();
                mqStatusDataVO.setQueueId(messageQueue.getQueueId());
                mqStatusDataVO.setQueue(messageQueue.toString());
                mqStatusDataVO.setMinOffset(topicOffset.getMinOffset());
                mqStatusDataVO.setMaxOffset(topicOffset.getMaxOffset());
                if (topicOffset.getLastUpdateTimestamp() != 0L) {
                    mqStatusDataVO.setLastUpdateTimeStamp(DateUtils.formatDateTime((Date)new Date(topicOffset.getLastUpdateTimestamp())));
                }
                statusDataVOList.add(mqStatusDataVO);
            }
            mqStatusVO.setItems(statusDataVOList);
            Collections.sort(statusDataVOList, new Comparator<MqStatusDataVO>(){

                @Override
                public int compare(MqStatusDataVO o1, MqStatusDataVO o2) {
                    RocketmqStatusDataVO tempO1 = (RocketmqStatusDataVO)o1;
                    RocketmqStatusDataVO tempO2 = (RocketmqStatusDataVO)o2;
                    return tempO1.getQueueId() - tempO2.getQueueId();
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("error when RocketmqMgrHandler status:", (Throwable)e);
            throw new KDException(BosErrorCode.rocketmqException, "error when RocketmqMgrHandler status", (Throwable)e);
        }
        return mqStatusVO;
    }

    @Override
    public MqConsumerVO consumers(final String topic) {
        MqConsumerVO mqConsumerVO = new MqConsumerVO(topic);
        ArrayList<MqFieldVO> consumersFields = new ArrayList<MqFieldVO>();
        consumersFields.add(new MqFieldVO("subscriptionGroup", LangRes.get("RocketmqMgrHandler_8", "Subscription Group", new Object[0])));
        consumersFields.add(new MqFieldVO("broker", LangRes.get("RocketmqMgrHandler_0", "Broker", new Object[0])));
        consumersFields.add(new MqFieldVO("queueId", LangRes.get("RocketmqMgrHandler_4", "Queue", new Object[0])));
        consumersFields.add(new MqFieldVO("consumerClient", LangRes.get("RocketmqMgrHandler_9", "Consumer Terminal", new Object[0])));
        consumersFields.add(new MqFieldVO("brokerOffset", LangRes.get("RocketmqMgrHandler_10", "Broker Offset", new Object[0])));
        consumersFields.add(new MqFieldVO("consumerOffset", LangRes.get("RocketmqMgrHandler_11", "Consumer Offset", new Object[0])));
        consumersFields.add(new MqFieldVO("diffTotal", LangRes.get("RocketmqMgrHandler_12", "Difference", new Object[0])));
        consumersFields.add(new MqFieldVO("lastTimeStamp", LangRes.get("RocketmqMgrHandler_13", "Last Time", new Object[0])));
        mqConsumerVO.setConsumersFields(consumersFields);
        DefaultMQAdminExt mqAdmin = this.getMQAdmin();
        if (mqAdmin == null) {
            return mqConsumerVO;
        }
        try {
            GroupList groupList = mqAdmin.queryTopicConsumeByWho(topic);
            if (CollectionUtils.isEmpty((Collection)groupList.getGroupList())) {
                return mqConsumerVO;
            }
            ArrayList<MqConsumerDataVO> consumerDataVOList = new ArrayList<MqConsumerDataVO>();
            mqConsumerVO.setItems(consumerDataVOList);
            for (String groupName : groupList.getGroupList()) {
                HashMap<MessageQueue, String> resultMap;
                ArrayList mqList;
                ConsumeStats consumeStats;
                block11: {
                    consumeStats = mqAdmin.examineConsumeStats(groupName, topic);
                    mqList = Lists.newArrayList((Iterable)Iterables.filter(consumeStats.getOffsetTable().keySet(), (Predicate)new Predicate<MessageQueue>(){

                        public boolean apply(MessageQueue o) {
                            return StringUtils.isBlank((String)topic) || o.getTopic().equals(topic);
                        }
                    }));
                    Collections.sort(mqList);
                    resultMap = new HashMap<MessageQueue, String>();
                    try {
                        ConsumerConnection consumerConnection = mqAdmin.examineConsumerConnectionInfo(groupName);
                        for (Connection connection : consumerConnection.getConnectionSet()) {
                            String clinetId = connection.getClientId();
                            ConsumerRunningInfo consumerRunningInfo = mqAdmin.getConsumerRunningInfo(groupName, clinetId, false);
                            for (MessageQueue messageQueue : consumerRunningInfo.getMqTable().keySet()) {
                                resultMap.put(messageQueue, clinetId);
                            }
                        }
                    }
                    catch (MQBrokerException mqBrokerException) {
                        if (mqBrokerException.getResponseCode() != 206) break block11;
                        for (MessageQueue mq : mqList) {
                            resultMap.put(mq, "");
                        }
                    }
                }
                RocketmqConsumerDataVO rocketmqConsumerDataVO = null;
                for (MessageQueue mq : mqList) {
                    OffsetWrapper offsetWrapper = (OffsetWrapper)consumeStats.getOffsetTable().get(mq);
                    rocketmqConsumerDataVO = new RocketmqConsumerDataVO();
                    consumerDataVOList.add(rocketmqConsumerDataVO);
                    rocketmqConsumerDataVO.setSubscriptionGroup(groupName);
                    rocketmqConsumerDataVO.setBroker(mq.getBrokerName());
                    rocketmqConsumerDataVO.setQueueId(mq.getQueueId());
                    rocketmqConsumerDataVO.setConsumerClient((String)resultMap.get(mq));
                    rocketmqConsumerDataVO.setBrokerOffset(offsetWrapper.getBrokerOffset());
                    rocketmqConsumerDataVO.setConsumerOffset(offsetWrapper.getConsumerOffset());
                    rocketmqConsumerDataVO.setDiffTotal(offsetWrapper.getBrokerOffset() - offsetWrapper.getConsumerOffset());
                    if (offsetWrapper.getLastTimestamp() == 0L) continue;
                    rocketmqConsumerDataVO.setLastTimeStamp(DateUtils.formatDateTime((Date)new Date(offsetWrapper.getLastTimestamp())));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("error when RocketmqMgrHandler consumers:", (Throwable)e);
            throw new KDException(BosErrorCode.rocketmqException, new Object[]{"error when RocketmqMgrHandler consumers"});
        }
        return mqConsumerVO;
    }

    public TopicList fetchAllTopicList(boolean skipSysProcess, boolean skipRetryAndDlq, String topicName, MqListVO mqListVO) {
        try {
            RocketInfo rocketInfo = this.getRocketInfo();
            TopicList allTopics = Objects.requireNonNull(this.getMQAdmin()).fetchTopicsByCLuster(rocketInfo.getClustername());
            mqListVO.setTotal_count(allTopics.getTopicList().size());
            TopicList sysTopics = this.getSystemTopicList();
            Set topics = allTopics.getTopicList().stream().map(topic -> {
                if (!skipSysProcess && sysTopics.getTopicList().contains(topic)) {
                    topic = String.format("%s%s", "%SYS%", topic);
                }
                return topic;
            }).filter(topic -> {
                if (topic.startsWith(rocketInfo.getVhost())) {
                    if (StringUtils.isNotEmpty((String)topicName)) {
                        return topic.contains(topicName);
                    }
                    return true;
                }
                if (!skipRetryAndDlq) {
                    return topic.startsWith("%RETRY%" + rocketInfo.getVhost()) && topic.contains(topicName) || topic.startsWith("%DLQ%" + rocketInfo.getVhost()) && topic.contains(topicName);
                }
                return false;
            }).collect(Collectors.toSet());
            allTopics.getTopicList().clear();
            allTopics.getTopicList().addAll(topics);
            return allTopics;
        }
        catch (Exception e) {
            LOGGER.error("error when RocketmqMgrHandler fetchAllTopicList:", (Throwable)e);
            throw new KDException(BosErrorCode.rocketmqException, "error when RocketmqMgrHandler fetchAllTopicList", (Throwable)e);
        }
    }

    private TopicList getSystemTopicList() {
        this.initProducer();
        try {
            return this.defaultMQProducer.getDefaultMQProducerImpl().getmQClientFactory().getMQClientAPIImpl().getSystemTopicList(20000L);
        }
        catch (Exception e) {
            LOGGER.error("error when RocketmqMgrHandler getSystemTopicList:", (Throwable)e);
            throw new KDException(BosErrorCode.rocketmqException, "error when RocketmqMgrHandler getSystemTopicList", (Throwable)e);
        }
    }

    private void initProducer() {
        if (this.defaultMQProducer == null) {
            try {
                RocketInfo rocketInfo = this.getRocketInfo();
                this.defaultMQProducer = (DefaultMQProducer)ProducerFactory.getProducer((String)"demo", (String)"demo_queue", (RocketInfo)rocketInfo);
            }
            catch (Exception e) {
                LOGGER.error("error when RocketmqMgrHandler initProducer:", (Throwable)e);
                throw new KDException(BosErrorCode.rocketmqException, "error when RocketmqMgrHandler initProducer", (Throwable)e);
            }
        }
    }
}

