/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest;

import java.util.HashMap;
import java.util.UUID;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.exception.KDException;
import kd.bos.eye.api.speedtest.SpeedTest;
import kd.bos.eye.api.speedtest.TestResultInfo;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MCSpeedTest
implements SpeedTest {
    private static final Log logger = LogFactory.getLog(MCSpeedTest.class);
    private String url;
    public static final String MC_API_GET_MC_DATA = "/kapi/app/mc/DataSaveGetService";

    public MCSpeedTest(String url) {
        this.url = url;
    }

    @Override
    public void doTest() {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("DCID", Instance.getClusterName());
        map.put("key", UUID.randomUUID().toString());
        try {
            MCApiUtil.getMCAPIInfo((String)MC_API_GET_MC_DATA, (boolean)true, null, map);
        }
        catch (Exception e) {
            if (e instanceof KDException) {
                if (!"626".equals(((KDException)e).getErrorCode().getCode())) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "MC";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getDes() {
        return "test getMCAPIInfo";
    }

    @Override
    public void getTestResult(TestResultInfo info) {
        try {
            long timestamp = this.test();
            info.setDes(this.getDes() + " " + this.getLastDetailTestInfo());
            if (timestamp >= 0L && timestamp <= 250L) {
                info.setStatus(1);
            } else if (timestamp > 250L && timestamp <= 500L) {
                info.setStatus(2);
            } else if (timestamp > 500L) {
                info.setStatus(3);
            }
            info.setTimestap(timestamp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            info.setTimestap(-1L);
            info.setDes(this.getDes() + ",exception:" + e.getMessage());
        }
    }

    @Override
    public String getStatusDes() {
        return LangRes.get("SpeedTestStatusDes_0", "Normal: {0}, Slow: {1}, Very Slow: {2}", "<=250ms", ">250ms&<=500ms", ">500ms");
    }
}

