/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest;

import kd.bos.eye.api.speedtest.TestResultInfo;
import kd.bos.eye.enterprise.LangRes;

public interface SpeedTest {
    public void doTest();

    public String getName();

    default public String getLastDetailTestInfo() {
        return "";
    }

    public String getUrl();

    public String getDes();

    default public long test() {
        long start = System.currentTimeMillis();
        this.doTest();
        return System.currentTimeMillis() - start;
    }

    default public void getTestResult(TestResultInfo info) {
        try {
            long timestamp = this.test();
            info.setDes(this.getDes() + " " + this.getLastDetailTestInfo());
            if (timestamp >= 0L && timestamp <= 10L) {
                info.setStatus(1);
            } else if (timestamp > 10L && timestamp <= 100L) {
                info.setStatus(2);
            } else if (timestamp > 100L) {
                info.setStatus(3);
            }
            info.setTimestap(timestamp);
        }
        catch (Exception e) {
            info.setTimestap(-1L);
            info.setDes(this.getDes() + ",exception:" + e.getMessage());
        }
    }

    default public String getStatusDes() {
        return LangRes.get("SpeedTestStatusDes_0", "Normal: {0}, Slow: {1}, Very Slow: {2}", "<=10ms", ">10ms&<=100ms", ">100ms");
    }
}

