/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.EyeExtendedHandlerHolder;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.speedtest.SpeedTestExecuter;
import kd.bos.eye.api.speedtest.TestResultInfo;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.WebPortUtil;

public class SpeedTestApiHandler
extends AbstractHttpHandler
implements EyeExtendedHandlerHolder {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String PROXY_PROTOCOL = "http://";
    private static final String SPEED_TEST = "/monitor/eye/speedtest";
    private static final Log log = LogFactory.getLog(SpeedTestApiHandler.class);
    private static final SpeedTestApiHandler instance = new SpeedTestApiHandler();

    public String[] getPaths() {
        return new String[]{"/eye/speedtest/", "/eye/speedtest"};
    }

    public HttpHandler getHandler() {
        return instance;
    }

    public boolean isApiClose() {
        return true;
    }

    protected void handle0(HttpExchange exchange) throws IOException {
        JSONObject jsonObject = this.requestForwardingToBos();
        if (StringUtils.isNotEmpty((String)((String)SessionStore.get().get(EyeAuther.getToken((HttpExchange)exchange)).get("user")))) {
            // empty if block
        }
        if (jsonObject != null) {
            this.writeJson(JSONUtils.toString((Object)jsonObject), exchange);
            return;
        }
        List<TestResultInfo> rs = SpeedTestExecuter.test(exchange);
        ArrayList resultList = new ArrayList();
        rs.forEach(v -> {
            SpeedTestResult speedTestResult = new SpeedTestResult();
            speedTestResult.setSubject(v.getName());
            speedTestResult.setUrl(v.getUrl());
            speedTestResult.setStatus(v.getStatus());
            String timeStamp = v.getTimestap() >= 0L ? v.getTimestap() + "ms" : "-";
            speedTestResult.setElapsedTime(timeStamp);
            speedTestResult.setDesc(v.getDes());
            speedTestResult.setStatusDesc(v.getStatusDes());
            resultList.add(speedTestResult);
        });
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("code", 0);
        response.put("data", resultList);
        response.put("msg", "success");
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private JSONObject requestForwardingToBos() {
        try {
            String url = this.getRequestUrl();
            if (StringUtils.isNotEmpty((String)url)) {
                Map proxyHeader = this.getProxyHeaderMap();
                return JSON.parseObject((String)EyeHttpClients.get((String)url, (Map)proxyHeader, (int)5000, (int)60000));
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRequestUrl() {
        block5: {
            block4: {
                if (!Instance.isAppSplit()) break block4;
                if (!WebPortUtil.isWebNode() || Instance.isWebMserviceInOne()) break block5;
                List serviceInfoList = ServiceInfoFactory.get().getServiceList();
                for (ServiceInfo serviceInfo : serviceInfoList) {
                    String[] appIds;
                    for (String appId : appIds = serviceInfo.getAppIds()) {
                        if (!"bos".equals(appId)) continue;
                        log.info("\u7ec4\u4ef6\u68c0\u6d4b-web\u8282\u70b9\u8df3\u8f6c\u5230\u7684bos\u5b9e\u4f8b\u4e3a\uff1a {},ip\u4e3a\uff1a {}", (Object)serviceInfo.getInstanceId(), (Object)serviceInfo.getIp());
                        return this.getSpeedTestUrl(serviceInfo.getIp(), serviceInfo.getHostMonitorPort());
                    }
                }
                break block5;
            }
            if (WebPortUtil.isWebNode() && !Instance.isWebMserviceInOne()) {
                List serviceInfoList = ServiceInfoFactory.get().getServiceList();
                for (ServiceInfo serviceInfo : serviceInfoList) {
                    String configAppName = serviceInfo.getConfigAppName();
                    if (!configAppName.contains("mservice")) continue;
                    log.info("\u7ec4\u4ef6\u68c0\u6d4b-web\u8282\u70b9\u8df3\u8f6c\u5230\u7684mservice\u5b9e\u4f8b\u4e3a\uff1a {},ip\u4e3a\uff1a {}", (Object)serviceInfo.getInstanceId(), (Object)serviceInfo.getIp());
                    return this.getSpeedTestUrl(serviceInfo.getIp(), serviceInfo.getHostMonitorPort());
                }
            }
        }
        return "";
    }

    private String getSpeedTestUrl(String ip, String port) {
        return PROXY_PROTOCOL + ip + ":" + port + SPEED_TEST;
    }

    private Map getProxyHeaderMap() {
        HashMap<String, String> proxyHeader = new HashMap<String, String>(1);
        proxyHeader.put(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
        return proxyHeader;
    }

    private static class SpeedTestResult {
        private String subject;
        private String url;
        private String elapsedTime;
        private String desc;
        private int status;
        private String statusDesc;

        private SpeedTestResult() {
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getElapsedTime() {
            return this.elapsedTime;
        }

        public void setElapsedTime(String elapsedTime) {
            this.elapsedTime = elapsedTime;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getStatusDesc() {
            return this.statusDesc;
        }

        public void setStatusDesc(String statusDesc) {
            this.statusDesc = statusDesc;
        }
    }
}

