/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest;

import com.sun.net.httpserver.HttpExchange;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.OperationContextCreator;
import kd.bos.eye.api.speedtest.FileServerTesterCreator;
import kd.bos.eye.api.speedtest.KDConnectionTesterCreator;
import kd.bos.eye.api.speedtest.MCTesterCreator;
import kd.bos.eye.api.speedtest.RedisTesterCreator;
import kd.bos.eye.api.speedtest.SpeedTest;
import kd.bos.eye.api.speedtest.TestResultInfo;
import kd.bos.eye.api.speedtest.TesterCreator;
import kd.bos.eye.api.speedtest.configservice.ConfigServiceTesterCreator;
import kd.bos.eye.api.speedtest.mq.MqTesterCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangContext;
import kd.bos.threads.ThreadPools;

public class SpeedTestExecuter {
    private static final Log log = LogFactory.getLog(SpeedTestExecuter.class);
    private static SpeedTestExecuter instance = new SpeedTestExecuter();
    private static List<TesterCreator> testers = new ArrayList<TesterCreator>();

    public static List<TestResultInfo> test(HttpExchange exchange) {
        List<SpeedTest> testls = instance.getSpeedTesters();
        ArrayList<TestResultInfo> testResult = new ArrayList<TestResultInfo>();
        CountDownLatch latch = new CountDownLatch(testls.size());
        testls.forEach(v -> {
            TestResultInfo tri = new TestResultInfo();
            tri.setName(v.getName());
            tri.setUrl(v.getUrl());
            tri.setTimestap(-1L);
            tri.setStatus(-1);
            tri.setStatusDes(v.getStatusDes());
            testResult.add(tri);
            ThreadPools.executeOnce((String)"speedtest", () -> {
                LangContext.setLangContext((HttpExchange)exchange);
                v.getTestResult(tri);
                latch.countDown();
            });
            LockSupport.parkNanos(10000L);
        });
        try {
            boolean await = latch.await(6L, TimeUnit.SECONDS);
            if (!await) {
                OperationContextCreator.getOrCreateForBos();
                log.warn("speed test is Interrupted");
            }
        }
        catch (InterruptedException e) {
            return testResult;
        }
        return testResult;
    }

    public static void registerTester(TesterCreator tester) {
        testers.add(tester);
    }

    private List<SpeedTest> getSpeedTesters() {
        ArrayList<SpeedTest> ls = new ArrayList<SpeedTest>();
        testers.forEach(tester -> ls.addAll(tester.getTesters()));
        return ls;
    }

    static {
        SpeedTestExecuter.registerTester(new RedisTesterCreator());
        SpeedTestExecuter.registerTester(new ConfigServiceTesterCreator());
        SpeedTestExecuter.registerTester(new KDConnectionTesterCreator());
        SpeedTestExecuter.registerTester(new MqTesterCreator());
        SpeedTestExecuter.registerTester(new MCTesterCreator());
        SpeedTestExecuter.registerTester(new FileServerTesterCreator());
    }
}

