/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest.configservice;

import kd.bos.eye.api.speedtest.SpeedTest;
import kd.bos.eye.api.speedtest.TestResultInfo;
import kd.bos.eye.enterprise.LangRes;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ZKSpeedTest
implements SpeedTest {
    private static final Log logger = LogFactory.getLog(ZKSpeedTest.class);
    private String url;
    private String testMethod;

    public ZKSpeedTest(String url) {
        this.url = url;
    }

    public ZKSpeedTest(String url, String testMethod) {
        this.url = url;
        this.testMethod = testMethod;
    }

    @Override
    public long test() {
        long testTime;
        if (this.testMethod == null) {
            long start = System.currentTimeMillis();
            this.doTest();
            return System.currentTimeMillis() - start;
        }
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)this.url);
            String rootPath = ZKFactory.getZkRootPath((String)this.url);
            String p = rootPath + Instance.getInstanceId() + "-zkspeedtest-" + this.testMethod;
            Stat exists = (Stat)client.checkExists().forPath(p);
            long start = System.currentTimeMillis();
            if (exists == null) {
                ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.PERSISTENT)).forPath(p);
            }
            long createTime = System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            client.delete().forPath(p);
            long delTime = System.currentTimeMillis() - start;
            testTime = "del".equals(this.testMethod) ? delTime : createTime;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return testTime;
    }

    @Override
    public void doTest() {
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)this.url);
            String rootPath = ZKFactory.getZkRootPath((String)this.url);
            String p = rootPath + Instance.getInstanceId() + "-zkspeedtest";
            Stat exists = (Stat)client.checkExists().forPath(p);
            if (exists == null) {
                ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.PERSISTENT)).forPath(p);
            }
            client.delete().forPath(p);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "Zookeeper";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getDes() {
        return this.testMethod == null ? "createPath/del" : this.testMethod;
    }

    @Override
    public void getTestResult(TestResultInfo info) {
        try {
            long timestamp = this.test();
            info.setDes(this.getDes() + " " + this.getLastDetailTestInfo());
            if (timestamp >= 0L && timestamp <= 10L) {
                info.setStatus(1);
            } else if (timestamp > 10L && timestamp <= 20L) {
                info.setStatus(2);
            } else if (timestamp > 20L) {
                info.setStatus(3);
            }
            info.setTimestap(timestamp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            info.setTimestap(-1L);
            info.setDes(this.getDes() + ",exception:" + e.getMessage());
        }
    }

    @Override
    public String getStatusDes() {
        return LangRes.get("SpeedTestStatusDes_0", "Normal: {0}, Slow: {1}, Very Slow: {2}", "<=10ms", ">10ms&<=20ms", ">20ms");
    }
}

