/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest.mq;

import java.security.SecureRandom;
import java.util.Random;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.eye.api.speedtest.SpeedTest;
import kd.bos.kafka.KafkaInfo;
import kd.bos.mq.kafka.ProducerFactory;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaSpeedTest
implements SpeedTest {
    private static Random random = new SecureRandom();
    private KafkaProducer<String, byte[]> producer;
    private String queueName;
    private String serverKey;
    private KafkaInfo kafkaInfo;

    public KafkaSpeedTest(KafkaProducer<String, byte[]> producer, String queueName, String region, String serverKey, KafkaInfo kafkaInfo) {
        this.producer = producer;
        this.queueName = queueName;
        this.serverKey = serverKey;
        this.kafkaInfo = kafkaInfo;
    }

    @Override
    public void doTest() {
        try {
            Message message = this.toMessage("kafka speed test");
            byte[] bytes = MessageSerde.get().encode(message);
            String groupAndTopicName = ProducerFactory.getTopicAndGroupName((String)this.kafkaInfo.getVhost(), (String)this.queueName);
            ProducerRecord record = new ProducerRecord(groupAndTopicName, (Object)bytes);
            this.producer.send(record);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "Mq";
    }

    @Override
    public String getUrl() {
        return "MqServerKey:" + this.serverKey + "," + this.kafkaInfo.getHost();
    }

    @Override
    public String getDes() {
        return "Kafka publish message to the demo queue";
    }

    private Message toMessage(Object body) {
        Message message = new Message();
        message.setBody(body);
        RequestContext rc = RequestContextCreator.createForMQ();
        message.setRequestContext(rc);
        message.setInnerId(random.nextLong());
        return message;
    }
}

