/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.speedtest.mq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.eye.api.mq.rabbit.ConfigPicker;
import kd.bos.eye.api.speedtest.SpeedTest;
import kd.bos.id.IDService;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.QueueManager;
import kd.bos.rabbitmq.RabbitmqFactory;

public class RabbitMqSpeedTest
implements SpeedTest {
    @Override
    public void doTest() {
        Connection connection = RabbitmqFactory.getConnection((String)"mq.server");
        try (Channel channel = connection.createChannel();){
            String queueName = QueueManager.getRealQueueName((String)"demo", (String)"demo_queue");
            byte[] bytes = MessageSerde.get().encode(this.toMessage("speed test"));
            channel.basicPublish("", queueName, null, bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "Mq";
    }

    @Override
    public String getUrl() {
        ConfigPicker configPicker = new ConfigPicker();
        return "MqServerKey:mq.server," + configPicker.getHost() + ":" + configPicker.getPort();
    }

    @Override
    public String getDes() {
        return "publish message to the demo queue";
    }

    private Message toMessage(Object body) {
        Message message = new Message();
        message.setBody(body);
        RequestContext rc = RequestContextCreator.createForMQ();
        message.setRequestContext(rc);
        message.setInnerId(IDService.get().genLongId());
        message.setMessageTime();
        return message;
    }
}

