/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.OperationContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.testspeed.KDConnectionTesterCreator;
import kd.bos.monitor.testspeed.RedisTesterCreator;
import kd.bos.monitor.testspeed.SpeedTest;
import kd.bos.monitor.testspeed.TestResultInfo;
import kd.bos.monitor.testspeed.TesterCreator;
import kd.bos.monitor.testspeed.ZKTesterCreator;
import kd.bos.monitor.testspeed.mq.BroadcastTesterCreator;
import kd.bos.monitor.testspeed.mq.MqTesterCreator;
import kd.bos.threads.ThreadPools;

public class SpeedTestExecuter {
    private static final Log log = LogFactory.getLog(SpeedTestExecuter.class);
    private static SpeedTestExecuter instance = new SpeedTestExecuter();
    private static List<TesterCreator> testers = new ArrayList<TesterCreator>();

    public static List<TestResultInfo> test() {
        List<SpeedTest> testls = instance.getSpeedTesters();
        ArrayList<TestResultInfo> testResult = new ArrayList<TestResultInfo>();
        CountDownLatch latch = new CountDownLatch(testls.size());
        testls.forEach(v -> {
            TestResultInfo tri = new TestResultInfo();
            tri.setDes(v.getDes());
            tri.setName(v.getName());
            tri.setTimestap(-1L);
            testResult.add(tri);
            ThreadPools.executeOnce((String)"speedtest", () -> {
                try {
                    tri.setTimestap(v.test());
                    tri.setDes(v.getDes() + "," + v.getLastDetailTestInfo());
                }
                catch (Exception e) {
                    tri.setTimestap(0L);
                    tri.setDes(tri.getDes() + ", exception:" + e + e.getMessage());
                }
                latch.countDown();
            });
            LockSupport.parkNanos(10000L);
        });
        try {
            boolean await = latch.await(6L, TimeUnit.SECONDS);
            if (!await) {
                OperationContextCreator.getOrCreateForBos();
                log.warn("test component timeout");
            }
        }
        catch (InterruptedException e) {
            return testResult;
        }
        return testResult;
    }

    public static void registerTester(TesterCreator tester) {
        testers.add(tester);
    }

    private List<SpeedTest> getSpeedTesters() {
        ArrayList<SpeedTest> ls = new ArrayList<SpeedTest>();
        testers.forEach(tester -> ls.addAll(tester.getTesters()));
        return ls;
    }

    static {
        SpeedTestExecuter.registerTester(new RedisTesterCreator());
        SpeedTestExecuter.registerTester(new ZKTesterCreator());
        SpeedTestExecuter.registerTester(new KDConnectionTesterCreator());
        SpeedTestExecuter.registerTester(new MqTesterCreator());
        SpeedTestExecuter.registerTester(new BroadcastTesterCreator());
    }
}

