/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed;

import kd.bos.instance.Instance;
import kd.bos.monitor.testspeed.SpeedTest;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ZKSpeedTest
implements SpeedTest {
    private String url;

    public ZKSpeedTest(String url) {
        this.url = url;
    }

    @Override
    public void doTest() {
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)this.url);
            String rootPath = ZKFactory.getZkRootPath((String)this.url);
            String p = rootPath + Instance.getInstanceId() + "-zkspeedtest";
            Stat exists = (Stat)client.checkExists().forPath(p);
            if (exists == null) {
                ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.PERSISTENT)).forPath(p);
            }
            client.delete().forPath(p);
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public String getName() {
        return "zookeeper:" + this.url;
    }

    @Override
    public String getDes() {
        return "zk (createPath/del)";
    }
}

