/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed.mq;

import java.security.SecureRandom;
import java.util.Random;
import kd.bos.context.OperationContextCreator;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.testspeed.SpeedTest;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.support.MessageSerde;
import kd.bos.rocketmq.RocketInfo;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.common.message.Message;

public class RocketMqSpeedTest
implements SpeedTest {
    private static final Log logger = LogFactory.getLog(RocketMqSpeedTest.class);
    private static Random random = new SecureRandom();
    private MQProducer producer;
    private String queueName;
    private String serverKey;
    private RocketInfo rocketInfo;

    public RocketMqSpeedTest(MQProducer producer, String queueName, String region, String serverKey, RocketInfo rocketInfo) {
        this.producer = producer;
        this.queueName = queueName;
        this.serverKey = serverKey;
        this.rocketInfo = rocketInfo;
    }

    @Override
    public void doTest() {
        try {
            OperationContextCreator.getOrCreateForBos();
            kd.bos.mq.support.Message message = this.toMessage("rocketmq speed test");
            byte[] bytes = MessageSerde.get().encode(message);
            String groupAndTopicName = ProducerFactory.getTopicAndGroupName((String)this.rocketInfo.getVhost(), (String)this.queueName);
            Message rocketMessage = new Message(groupAndTopicName, "*", bytes);
            this.producer.send(rocketMessage);
        }
        catch (Exception e) {
            logger.error("test RocketMq connect exception", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "MqServerKey:" + this.serverKey + "," + this.rocketInfo.getHost();
    }

    @Override
    public String getDes() {
        return "RocketMq publish message to the demo queue";
    }

    private kd.bos.mq.support.Message toMessage(Object body) {
        kd.bos.mq.support.Message message = new kd.bos.mq.support.Message();
        message.setBody(body);
        RequestContext rc = RequestContextCreator.createForMQ();
        message.setRequestContext(rc);
        message.setInnerId(random.nextLong());
        return message;
    }
}

