/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed.serviceindicator;

import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.mservice.monitor.LimitQueue;
import kd.bos.mservice.monitor.items.Indicator;

public abstract class AbstractIndicator
implements Indicator {
    private LimitQueue<Double> cacheStatus = new LimitQueue(6);
    private LimitQueue<Long> timeSpends = new LimitQueue(5);
    protected AtomicInteger count = new AtomicInteger(0);
    private Throwable testException;
    private boolean isError;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r);
        thread.setName(this.getClass().getSimpleName() + "Scheduled-%d");
        thread.setDaemon(true);
        return thread;
    });

    protected int getAvgMs() {
        Double preindicator = (Double)this.cacheStatus.getLast();
        if (preindicator == null) {
            return 0;
        }
        return preindicator.intValue();
    }

    protected String getTestTime() {
        return "lastest speed test time(ms): " + this.timeSpends.getAll().toString();
    }

    protected int getOverTimeCount(long std) {
        int count = 0;
        Iterator iterator = this.timeSpends.getAll().iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            if (l <= std) continue;
            ++count;
        }
        return count;
    }

    public void touch() {
        try {
            this.count.incrementAndGet();
            this.scheduler.schedule(() -> {
                long begin = System.currentTimeMillis();
                try {
                    this.doTest();
                    long costMills = System.currentTimeMillis() - begin;
                    this.cacheStatus.offer((Object)this.getOfferVal(costMills));
                    this.timeSpends.offer((Object)costMills);
                    if (!this.isError) {
                        this.testException = null;
                    }
                }
                catch (Exception e) {
                    this.cacheStatus.offer((Object)this.getOfferVal(100000L));
                    this.timeSpends.offer((Object)100000L);
                    this.testException = e;
                    this.isError = this.checkException(e);
                }
                finally {
                    this.count.decrementAndGet();
                }
            }, 1L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean checkException(Exception e) {
        return false;
    }

    public abstract void doTest();

    private double getOfferVal(long t) {
        int itemsize = this.cacheStatus.size();
        if (itemsize == 0) {
            return t;
        }
        double preindicator = (Double)this.cacheStatus.getLast();
        double avgval = (preindicator * (double)itemsize + (double)t) / (double)(itemsize + 1);
        return avgval;
    }

    public boolean canResponse() {
        return true;
    }

    public boolean isError() {
        return this.isError;
    }

    public Throwable getTestException() {
        return this.testException;
    }
}

