/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.testspeed.serviceindicator;

import java.security.SecureRandom;
import java.util.List;
import kd.bos.monitor.testspeed.KDConnectionTesterCreator;
import kd.bos.monitor.testspeed.SpeedTest;
import kd.bos.monitor.testspeed.serviceindicator.AbstractIndicator;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.config.CommonIndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangSupplier;

public class DBIndicator
extends AbstractIndicator
implements IndicatorConfigurable {
    private KDConnectionTesterCreator creatror = new KDConnectionTesterCreator();
    private final SecureRandom random = new SecureRandom();
    private ItemConfig config = new ItemConfig();

    public HealthLevel getHealthLevel() {
        if (this.count.get() > 3) {
            return HealthLevel.OVERLOAD;
        }
        int avgMs = this.getAvgMs();
        if (avgMs <= this.config.normalMaxValue) {
            return HealthLevel.NORMAL;
        }
        if (avgMs <= this.config.busyMaxValue) {
            return HealthLevel.BUSY;
        }
        if (avgMs <= this.config.overloadMaxValue) {
            return HealthLevel.OVERLOAD;
        }
        return HealthLevel.OVERLOAD;
    }

    public String getName() {
        return "db";
    }

    public String getDesc() {
        return this.getName() + ":" + kd.bos.eye.enterprise.LangRes.get("DBIndicator_1", "Current node access time to DB. When it exceeds the threshold, the node is busy or overloaded.", new Object[0]);
    }

    @Override
    public void doTest() {
        if (this.count.get() > 5) {
            return;
        }
        List<SpeedTest> testors = this.creatror.getTesters();
        int index = this.random.nextInt(testors.size());
        testors.get(index).doTest();
    }

    public boolean isOnlyMservice() {
        return true;
    }

    public String getHealthDetail() {
        if (this.count.get() > 3) {
            return "over 3 times speedTest not response";
        }
        return "avg access test time(ms):" + this.getAvgMs();
    }

    public boolean $configEnable() {
        return this.config.isEnable();
    }

    public IndicatorItemConfig getIndicatorConfig() {
        return this.config;
    }

    private static class ItemConfig
    extends CommonIndicatorItemConfig {
        private int normalMaxValue = 200;
        private int busyMaxValue = 500;
        private int overloadMaxValue = 2000;

        private ItemConfig() {
        }

        public void initFieldMeta() {
            super.initFieldMeta();
            ConfigItemMeta normalMaxValueFiledMeta = new ConfigItemMeta("normalMaxValue").withDefaultValue((Object)200).withDisplayLabelName(new LangSupplier(LangRes.eyeapienterprise, "DBIndicator_2", "Normal maximum response time (ms)"));
            this.initInfosMap.put(normalMaxValueFiledMeta.getFiledName(), normalMaxValueFiledMeta);
            ConfigItemMeta busyMaxValueFiledMeta = new ConfigItemMeta("busyMaxValue").withDefaultValue((Object)500).withDisplayLabelName(new LangSupplier(LangRes.eyeapienterprise, "DBIndicator_3", "Busy maximum response time (ms)"));
            this.initInfosMap.put(busyMaxValueFiledMeta.getFiledName(), busyMaxValueFiledMeta);
            ConfigItemMeta overloadMaxValueFiledMeta = new ConfigItemMeta("overloadMaxValue").withDefaultValue((Object)1000).withDisplayLabelName(new LangSupplier(LangRes.eyeapienterprise, "DBIndicator_4", "Overloaded maximum response time (ms)"));
            this.initInfosMap.put(overloadMaxValueFiledMeta.getFiledName(), overloadMaxValueFiledMeta);
        }
    }
}

