/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.springboot;

import java.util.concurrent.locks.LockSupport;
import kd.bos.util.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;

@SpringBootApplication
@EnableFeignClients
public class SpringbootApplicationServer {
    private static final Logger log = LoggerFactory.getLogger(SpringbootApplicationServer.class);

    public static void main(String[] args) {
        try {
            String mainConfigClass = SystemProperties.getWithEnv((String)"spring.application.main.config.class");
            if (mainConfigClass != null && mainConfigClass.length() > 0) {
                String[] tempClasses = mainConfigClass.split(",|;");
                Class[] mainConfigClasses = new Class[tempClasses.length + 1];
                mainConfigClasses[0] = SpringbootApplicationServer.class;
                for (int i = 0; i < tempClasses.length; ++i) {
                    String tempClass = tempClasses[i];
                    try {
                        Class<?> newClass;
                        mainConfigClasses[i + 1] = newClass = Class.forName(tempClass, false, ClassLoader.getSystemClassLoader());
                        continue;
                    }
                    catch (Exception e) {
                        log.error("loadSpringMainConfigClassError,", (Throwable)e);
                    }
                }
                SpringApplication.run((Class[])mainConfigClasses, (String[])args);
            } else {
                SpringApplication.run(SpringbootApplicationServer.class, (String[])args);
            }
        }
        catch (Error | Exception e) {
            log.error("start springboot server SpringbootApplicationServer error,Execute System.exit(1) Starting to exit the service", e);
            LockSupport.parkNanos(2000000000L);
            System.exit(1);
        }
    }
}

