/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.springboot.webserver.tomcat;

import java.io.IOException;
import kd.bos.eye.httpserver.EyeInstaller;
import kd.bos.monitor.httpserver.MonitorInstaller;
import kd.bos.service.web.WebResourceUtils;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;

public class TomcatServletWebServerFactoryImpl
extends TomcatServletWebServerFactory {
    private static final String containerSciFilter = "org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer|org.eclipse.jetty.websocket.server.NativeWebSocketServletContainerInitializer|com.apusic.aas.websocket.server.WsSci|com.tongweb.web.websocket.server.WsSci|com.bes.enterprise.web.websocket.server.WsSci|com.bes.enterprise.web.jasper.servlet.JasperInitializer";

    public TomcatServletWebServerFactoryImpl(String contextPath, int port) {
        super(contextPath, port);
    }

    protected void postProcessContext(Context contextIerp) {
        String webappPath = TomcatServletWebServerFactoryImpl.getProperty("JETTY_WEBAPP_PATH", "webapp");
        contextIerp.setDocBase(webappPath);
        StandardJarScanner scannerIerp = (StandardJarScanner)contextIerp.getJarScanner();
        scannerIerp.setJarScanFilter((JarScanFilter)new StandardJarScanFilter(){

            public boolean isSkipAll() {
                return true;
            }
        });
        contextIerp.setContainerSciFilter(containerSciFilter);
        contextIerp.addApplicationListener("kd.bos.msgjet.websocket.tomcat.TomcatWsContextListener");
        ContextConfig contextConfig = new ContextConfig();
        String source = TomcatServletWebServerFactoryImpl.getProperty("JETTY_WEBXML_PATH", TomcatServletWebServerFactoryImpl.class.getClassLoader().getResource(WebResourceUtils.getWebReousrceXmlPath()).getPath());
        contextConfig.setDefaultWebXml("jar:" + source);
        contextIerp.addLifecycleListener((LifecycleListener)contextConfig);
        this.monitorInstall(contextIerp);
        try {
            MonitorInstaller.installIerp((Object)contextIerp);
            EyeInstaller.installIerp((Object)contextIerp);
        }
        catch (IOException e) {
            throw new Error("TomcatServletWebServerFactoryImpl MonitorInstaller.installIerp exception:" + e.getMessage(), e);
        }
        super.postProcessContext(contextIerp);
    }

    protected TomcatWebServer getTomcatWebServer(Tomcat tomcat) {
        StandardContext context = new StandardContext();
        context.setPath("");
        StandardJarScanner jarScanner = (StandardJarScanner)context.getJarScanner();
        jarScanner.setJarScanFilter((JarScanFilter)new StandardJarScanFilter(){

            public boolean isSkipAll() {
                return true;
            }
        });
        context.setContainerSciFilter(containerSciFilter);
        context.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
        tomcat.getHost().addChild((Container)context);
        this.monitorInstall((Context)context);
        return super.getTomcatWebServer(tomcat);
    }

    private void monitorInstall(Context context) {
        try {
            MonitorInstaller.install((Object)context);
            EyeInstaller.install((Object)context);
        }
        catch (IOException e) {
            throw new Error("EmbedTomcatServer monitorInstall IOException:" + e.getMessage(), e);
        }
    }

    private static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

