/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elect;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.elect.Elector;
import kd.bos.elect.impl.redis.RedisCompeteElectorImpl;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class ElectFactory {
    private static Map<String, Elector> electors = new ConcurrentHashMap<String, Elector>(2);
    private static String ELECT_TYPE = "bos.elect.type";

    public static Elector getElector(String electClusterName) {
        String type = System.getProperty(ELECT_TYPE, "redis");
        if ("redis".equals(type)) {
            return electors.computeIfAbsent(electClusterName, k -> new RedisCompeteElectorImpl(electClusterName));
        }
        throw new KDException(BosErrorCode.unsupportedConfigType, new Object[]{type});
    }
}

