/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elect.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.elect.ElectNodesLostListener;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.elect.impl.ElectErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;

public abstract class CompeteElector
implements Elector {
    private String electClusterName = "dts";
    private int heartbeatIntervalSeconds = 3;
    private int heartbeatTimeOutSeconds = this.heartbeatIntervalSeconds * 3 + 1;
    private Map<String, ElectorListener> listeners = new ConcurrentHashMap<String, ElectorListener>(1);
    private final Map<String, ElectNodesLostListener> nodeLostlisteners = new ConcurrentHashMap<String, ElectNodesLostListener>(1);
    private AtomicBoolean isStarted = new AtomicBoolean();
    protected final String masterKey;
    protected final String electNodesKey;

    public CompeteElector(String systemName) {
        this.electClusterName = systemName;
        this.masterKey = this.getMasterKey(systemName);
        this.electNodesKey = this.getElectNodesKey(systemName);
    }

    public CompeteElector(String systemName, int heartbeatIntervalSeconds) {
        this.electClusterName = systemName;
        this.setHeartbeatIntervalSeconds(heartbeatIntervalSeconds);
        this.masterKey = this.getMasterKey(systemName);
        this.electNodesKey = this.getElectNodesKey(systemName);
    }

    private String getMasterKey(String systemName) {
        return Instance.getClusterName() + "_" + systemName + "_master" + System.getProperty("elect.Region", "");
    }

    private String getElectNodesKey(String systemName) {
        return Instance.getClusterName() + "_" + systemName + "_elect_nodes" + System.getProperty("elect.Region", "");
    }

    public String getElectClusterName() {
        return this.electClusterName;
    }

    public int getHeartbeatTimeOutSeconds() {
        return this.heartbeatTimeOutSeconds;
    }

    public void setHeartbeatTimeOutSeconds(int heartbeatTimeOutSeconds) {
        this.heartbeatTimeOutSeconds = heartbeatTimeOutSeconds;
    }

    public int getHeartbeatIntervalSeconds() {
        return this.heartbeatIntervalSeconds;
    }

    public final void setHeartbeatIntervalSeconds(int heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }

    @Override
    public void registerListener(ElectorListener listener) {
        String key = listener.getClass().getName();
        this.listeners.computeIfAbsent(key, k -> listener);
    }

    @Override
    public void unRegisterListener(ElectorListener listener) {
        String key = listener.getClass().getName();
        this.listeners.remove(key);
    }

    @Override
    public void registerNodesLostListener(ElectNodesLostListener listener) {
        String key = listener.getClass().getName();
        this.nodeLostlisteners.computeIfAbsent(key, k -> listener);
    }

    @Override
    public void unRegisterNodesLostListener(ElectNodesLostListener listener) {
        String key = listener.getClass().getName();
        this.nodeLostlisteners.remove(key);
    }

    protected boolean interestedNodesLostEvent() {
        return !this.nodeLostlisteners.isEmpty();
    }

    protected void notifyNodeLost(String instanceId) {
        this.nodeLostlisteners.forEach((k, listener) -> listener.notifyNodesLost(instanceId));
    }

    protected void notifyMaster() {
        this.listeners.forEach((k, listener) -> listener.notifyMaster());
    }

    protected void notifyLostMaster() {
        this.listeners.forEach((k, listener) -> listener.notifyLostMaster());
    }

    @Override
    public synchronized void start() {
        if (!this.isStarted.get()) {
            this.doStart();
            this.isStarted.compareAndSet(false, true);
        }
    }

    protected abstract void doStart();

    protected void checkStarted() {
        if (!this.isStarted.get()) {
            throw new KDException(ElectErrorCode.notStartedError, new Object[]{this.getElectClusterName()});
        }
    }

    @Override
    public synchronized void close() {
        if (this.isStarted.get()) {
            this.doClose();
            this.isStarted.compareAndSet(true, false);
        }
    }

    protected abstract void doClose();
}

